/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import io.lindstrom.mpd.data.Range;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class Metrics {
    @XmlElement(name="Reporting", required=true, namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> reportings;
    @XmlElement(name="Range", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Range> ranges;
    @XmlAttribute(name="metrics", required=true)
    private final String metrics;

    private Metrics(List<Descriptor> reportings, List<Range> ranges, String metrics) {
        this.reportings = reportings;
        this.ranges = ranges;
        this.metrics = metrics;
    }

    private Metrics() {
        this.reportings = null;
        this.ranges = null;
        this.metrics = null;
    }

    public List<Descriptor> getReportings() {
        return Utils.unmodifiableList(this.reportings);
    }

    public List<Range> getRanges() {
        return Utils.unmodifiableList(this.ranges);
    }

    public String getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metrics metrics1 = (Metrics)o;
        return Objects.equals(this.reportings, metrics1.reportings) && Objects.equals(this.ranges, metrics1.ranges) && Objects.equals(this.metrics, metrics1.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.reportings, this.ranges, this.metrics);
    }

    public String toString() {
        return "Metrics{reportings=" + this.reportings + ", ranges=" + this.ranges + ", metrics='" + this.metrics + '\'' + '}';
    }

    public Builder buildUpon() {
        return new Builder().withReportings(this.reportings).withRanges(this.ranges).withMetrics(this.metrics);
    }

    public static class Builder {
        private List<Descriptor> reportings;
        private List<Range> ranges;
        private String metrics;

        public Builder withReportings(List<Descriptor> reportings) {
            this.reportings = reportings;
            return this;
        }

        public Builder withRanges(List<Range> ranges) {
            this.ranges = ranges;
            return this;
        }

        public Builder withMetrics(String metrics) {
            this.metrics = metrics;
            return this;
        }

        public Metrics build() {
            return new Metrics(this.reportings, this.ranges, this.metrics);
        }
    }
}

