/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import io.lindstrom.mpd.data.Ratio;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"accessibility", "role", "rating", "viewpoint", "any"})
public class ContentComponent {
    @XmlElement(name="Accessibility", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> accessibilities;
    @XmlElement(name="Role", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> roles;
    @XmlElement(name="Rating", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> ratings;
    @XmlElement(name="Viewpoint", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> viewpoints;
    @XmlAttribute(name="id")
    private final Long id;
    @XmlAttribute(name="lang")
    private final String lang;
    @XmlAttribute(name="contentType")
    private final String contentType;
    @XmlAttribute(name="par")
    private final Ratio par;

    private ContentComponent(List<Descriptor> accessibilities, List<Descriptor> roles, List<Descriptor> ratings, List<Descriptor> viewpoints, Long id, String lang, String contentType, Ratio par) {
        this.accessibilities = accessibilities;
        this.roles = roles;
        this.ratings = ratings;
        this.viewpoints = viewpoints;
        this.id = id;
        this.lang = lang;
        this.contentType = contentType;
        this.par = par;
    }

    private ContentComponent() {
        this.accessibilities = null;
        this.roles = null;
        this.ratings = null;
        this.viewpoints = null;
        this.id = null;
        this.lang = null;
        this.contentType = null;
        this.par = null;
    }

    public List<Descriptor> getAccessibilities() {
        return Utils.unmodifiableList(this.accessibilities);
    }

    public List<Descriptor> getRoles() {
        return Utils.unmodifiableList(this.roles);
    }

    public List<Descriptor> getRatings() {
        return Utils.unmodifiableList(this.ratings);
    }

    public List<Descriptor> getViewpoints() {
        return Utils.unmodifiableList(this.viewpoints);
    }

    public Long getId() {
        return this.id;
    }

    public String getLang() {
        return this.lang;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Ratio getPar() {
        return this.par;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentComponent that = (ContentComponent)o;
        return Objects.equals(this.accessibilities, that.accessibilities) && Objects.equals(this.roles, that.roles) && Objects.equals(this.ratings, that.ratings) && Objects.equals(this.viewpoints, that.viewpoints) && Objects.equals(this.id, that.id) && Objects.equals(this.lang, that.lang) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.par, that.par);
    }

    public int hashCode() {
        return Objects.hash(this.accessibilities, this.roles, this.ratings, this.viewpoints, this.id, this.lang, this.contentType, this.par);
    }

    public String toString() {
        return "ContentComponent{accessibilities=" + this.accessibilities + ", roles=" + this.roles + ", ratings=" + this.ratings + ", viewpoints=" + this.viewpoints + ", id=" + this.id + ", lang='" + this.lang + '\'' + ", contentType='" + this.contentType + '\'' + ", par='" + this.par + '\'' + '}';
    }

    public Builder buildUpon() {
        return new Builder().withAccessibilities(this.accessibilities).withRoles(this.roles).withRatings(this.ratings).withViewpoints(this.viewpoints).withId(this.id).withLang(this.lang).withContentType(this.contentType).withPar(this.par);
    }

    public static class Builder {
        private List<Descriptor> accessibilities;
        private List<Descriptor> roles;
        private List<Descriptor> ratings;
        private List<Descriptor> viewpoints;
        private Long id;
        private String lang;
        private String contentType;
        private Ratio par;

        public Builder withAccessibilities(List<Descriptor> accessibilities) {
            this.accessibilities = accessibilities;
            return this;
        }

        public Builder withRoles(List<Descriptor> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withRatings(List<Descriptor> ratings) {
            this.ratings = ratings;
            return this;
        }

        public Builder withViewpoints(List<Descriptor> viewpoints) {
            this.viewpoints = viewpoints;
            return this;
        }

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withPar(Ratio par) {
            this.par = par;
            return this;
        }

        public ContentComponent build() {
            return new ContentComponent(this.accessibilities, this.roles, this.ratings, this.viewpoints, this.id, this.lang, this.contentType, this.par);
        }
    }
}

