/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.mpd.data;

import io.lindstrom.mpd.data.ActuateType;
import io.lindstrom.mpd.data.BaseURL;
import io.lindstrom.mpd.data.ContentComponent;
import io.lindstrom.mpd.data.EventStream;
import io.lindstrom.mpd.data.FrameRate;
import io.lindstrom.mpd.data.Ratio;
import io.lindstrom.mpd.data.Representation;
import io.lindstrom.mpd.data.RepresentationBase;
import io.lindstrom.mpd.data.SegmentBase;
import io.lindstrom.mpd.data.SegmentList;
import io.lindstrom.mpd.data.SegmentTemplate;
import io.lindstrom.mpd.data.VideoScanType;
import io.lindstrom.mpd.data.descriptor.Descriptor;
import io.lindstrom.mpd.data.descriptor.Role;
import io.lindstrom.mpd.support.Utils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"id", "contentType", "mimeType", "segmentAlignment", "framePackings", "audioChannelConfigurations", "contentProtections", "essentialProperties", "supplementalProperties", "inbandEventStreams", "accessibilities", "roles", "ratings", "viewpoints", "contentComponents", "baseURLs", "segmentBase", "segmentList", "segmentTemplate", "representations"})
public class AdaptationSet
extends RepresentationBase {
    @XmlElement(name="Accessibility", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> accessibilities;
    @XmlElement(name="Role", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> roles;
    @XmlElement(name="Rating", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> ratings;
    @XmlElement(name="Viewpoint", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Descriptor> viewpoints;
    @XmlElement(name="ContentComponent", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<ContentComponent> contentComponents;
    @XmlElement(name="BaseURL", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<BaseURL> baseURLs;
    @XmlElement(name="SegmentBase", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentBase segmentBase;
    @XmlElement(name="SegmentList", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentList segmentList;
    @XmlElement(name="SegmentTemplate", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final SegmentTemplate segmentTemplate;
    @XmlElement(name="Representation", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Representation> representations;
    @XmlAttribute(name="href", namespace="http://www.w3.org/1999/xlink")
    private final String href;
    @XmlAttribute(name="actuate", namespace="http://www.w3.org/1999/xlink")
    private final ActuateType actuate;
    @XmlAttribute(name="id")
    private final Long id;
    @XmlAttribute(name="group")
    private final Long group;
    @XmlAttribute(name="lang")
    private final String lang;
    @XmlAttribute(name="contentType")
    private final String contentType;
    @XmlAttribute(name="par")
    private final Ratio par;
    @XmlAttribute(name="minBandwidth")
    private final Long minBandwidth;
    @XmlAttribute(name="maxBandwidth")
    private final Long maxBandwidth;
    @XmlAttribute(name="minWidth")
    private final Long minWidth;
    @XmlAttribute(name="maxWidth")
    private final Long maxWidth;
    @XmlAttribute(name="minHeight")
    private final Long minHeight;
    @XmlAttribute(name="maxHeight")
    private final Long maxHeight;
    @XmlAttribute(name="minFrameRate")
    private final FrameRate minFrameRate;
    @XmlAttribute(name="maxFrameRate")
    private final FrameRate maxFrameRate;
    @XmlAttribute(name="segmentAlignment")
    private final String segmentAlignment;
    @XmlAttribute(name="subsegmentAlignment")
    private final String subsegmentAlignment;
    @XmlAttribute(name="subsegmentStartsWithSAP")
    private final Long subsegmentStartsWithSAP;
    @XmlAttribute(name="bitstreamSwitching")
    private final Boolean bitstreamSwitching;

    private AdaptationSet(List<Descriptor> framePackings, List<Descriptor> audioChannelConfigurations, List<Descriptor> contentProtections, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, List<EventStream> inbandEventStreams, String profiles, Long width, Long height, Ratio sar, FrameRate frameRate, String audioSamplingRate, String mimeType, String segmentProfiles, String codecs, Double maximumSAPPeriod, Long startWithSAP, Double maxPlayoutRate, Boolean codingDependency, VideoScanType scanType, List<Descriptor> accessibilities, List<Descriptor> roles, List<Descriptor> ratings, List<Descriptor> viewpoints, List<ContentComponent> contentComponents, List<BaseURL> baseURLs, SegmentBase segmentBase, SegmentList segmentList, SegmentTemplate segmentTemplate, List<Representation> representations, String href, ActuateType actuate, Long id, Long group, String lang, String contentType, Ratio par, Long minBandwidth, Long maxBandwidth, Long minWidth, Long maxWidth, Long minHeight, Long maxHeight, FrameRate minFrameRate, FrameRate maxFrameRate, String segmentAlignment, String subsegmentAlignment, Long subsegmentStartsWithSAP, Boolean bitstreamSwitching) {
        super(framePackings, audioChannelConfigurations, contentProtections, essentialProperties, supplementalProperties, inbandEventStreams, profiles, width, height, sar, frameRate, audioSamplingRate, mimeType, segmentProfiles, codecs, maximumSAPPeriod, startWithSAP, maxPlayoutRate, codingDependency, scanType);
        this.accessibilities = accessibilities;
        this.roles = roles;
        this.ratings = ratings;
        this.viewpoints = viewpoints;
        this.contentComponents = contentComponents;
        this.baseURLs = baseURLs;
        this.segmentBase = segmentBase;
        this.segmentList = segmentList;
        this.segmentTemplate = segmentTemplate;
        this.representations = representations;
        this.href = href;
        this.actuate = actuate;
        this.id = id;
        this.group = group;
        this.lang = lang;
        this.contentType = contentType;
        this.par = par;
        this.minBandwidth = minBandwidth;
        this.maxBandwidth = maxBandwidth;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minFrameRate = minFrameRate;
        this.maxFrameRate = maxFrameRate;
        this.segmentAlignment = segmentAlignment;
        this.subsegmentAlignment = subsegmentAlignment;
        this.subsegmentStartsWithSAP = subsegmentStartsWithSAP;
        this.bitstreamSwitching = bitstreamSwitching;
    }

    private AdaptationSet() {
        this.accessibilities = null;
        this.roles = null;
        this.ratings = null;
        this.viewpoints = null;
        this.contentComponents = null;
        this.baseURLs = null;
        this.segmentBase = null;
        this.segmentList = null;
        this.segmentTemplate = null;
        this.representations = null;
        this.href = null;
        this.actuate = null;
        this.id = null;
        this.group = null;
        this.lang = null;
        this.contentType = null;
        this.par = null;
        this.minBandwidth = null;
        this.maxBandwidth = null;
        this.minWidth = null;
        this.maxWidth = null;
        this.minHeight = null;
        this.maxHeight = null;
        this.minFrameRate = null;
        this.maxFrameRate = null;
        this.segmentAlignment = null;
        this.subsegmentAlignment = null;
        this.subsegmentStartsWithSAP = null;
        this.bitstreamSwitching = null;
    }

    public List<Descriptor> getAccessibilities() {
        return Utils.unmodifiableList(this.accessibilities);
    }

    public List<Descriptor> getRoles() {
        return Utils.unmodifiableList(this.roles);
    }

    public List<Descriptor> getRatings() {
        return Utils.unmodifiableList(this.ratings);
    }

    public List<Descriptor> getViewpoints() {
        return Utils.unmodifiableList(this.viewpoints);
    }

    public List<ContentComponent> getContentComponents() {
        return Utils.unmodifiableList(this.contentComponents);
    }

    public List<BaseURL> getBaseURLs() {
        return Utils.unmodifiableList(this.baseURLs);
    }

    public SegmentBase getSegmentBase() {
        return this.segmentBase;
    }

    public SegmentList getSegmentList() {
        return this.segmentList;
    }

    public SegmentTemplate getSegmentTemplate() {
        return this.segmentTemplate;
    }

    public List<Representation> getRepresentations() {
        return Utils.unmodifiableList(this.representations);
    }

    public String getHref() {
        return this.href;
    }

    public ActuateType getActuate() {
        return this.actuate;
    }

    public Long getId() {
        return this.id;
    }

    public Long getGroup() {
        return this.group;
    }

    public String getLang() {
        return this.lang;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Ratio getPar() {
        return this.par;
    }

    public Long getMinBandwidth() {
        return this.minBandwidth;
    }

    public Long getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public Long getMinWidth() {
        return this.minWidth;
    }

    public Long getMaxWidth() {
        return this.maxWidth;
    }

    public Long getMinHeight() {
        return this.minHeight;
    }

    public Long getMaxHeight() {
        return this.maxHeight;
    }

    public FrameRate getMinFrameRate() {
        return this.minFrameRate;
    }

    public FrameRate getMaxFrameRate() {
        return this.maxFrameRate;
    }

    public String getSegmentAlignment() {
        return this.segmentAlignment;
    }

    public String getSubsegmentAlignment() {
        return this.subsegmentAlignment;
    }

    public Long getSubsegmentStartsWithSAP() {
        return this.subsegmentStartsWithSAP;
    }

    public Boolean getBitstreamSwitching() {
        return this.bitstreamSwitching;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdaptationSet that = (AdaptationSet)o;
        return Objects.equals(this.accessibilities, that.accessibilities) && Objects.equals(this.roles, that.roles) && Objects.equals(this.ratings, that.ratings) && Objects.equals(this.viewpoints, that.viewpoints) && Objects.equals(this.contentComponents, that.contentComponents) && Objects.equals(this.baseURLs, that.baseURLs) && Objects.equals(this.segmentBase, that.segmentBase) && Objects.equals(this.segmentList, that.segmentList) && Objects.equals(this.segmentTemplate, that.segmentTemplate) && Objects.equals(this.representations, that.representations) && Objects.equals(this.href, that.href) && this.actuate == that.actuate && Objects.equals(this.id, that.id) && Objects.equals(this.group, that.group) && Objects.equals(this.lang, that.lang) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.par, that.par) && Objects.equals(this.minBandwidth, that.minBandwidth) && Objects.equals(this.maxBandwidth, that.maxBandwidth) && Objects.equals(this.minWidth, that.minWidth) && Objects.equals(this.maxWidth, that.maxWidth) && Objects.equals(this.minHeight, that.minHeight) && Objects.equals(this.maxHeight, that.maxHeight) && Objects.equals(this.minFrameRate, that.minFrameRate) && Objects.equals(this.maxFrameRate, that.maxFrameRate) && Objects.equals(this.segmentAlignment, that.segmentAlignment) && Objects.equals(this.subsegmentAlignment, that.subsegmentAlignment) && Objects.equals(this.subsegmentStartsWithSAP, that.subsegmentStartsWithSAP) && Objects.equals(this.bitstreamSwitching, that.bitstreamSwitching);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.accessibilities, this.roles, this.ratings, this.viewpoints, this.contentComponents, this.baseURLs, this.segmentBase, this.segmentList, this.segmentTemplate, this.representations, this.href, this.actuate, this.id, this.group, this.lang, this.contentType, this.par, this.minBandwidth, this.maxBandwidth, this.minWidth, this.maxWidth, this.minHeight, this.maxHeight, this.minFrameRate, this.maxFrameRate, this.segmentAlignment, this.subsegmentAlignment, this.subsegmentStartsWithSAP, this.bitstreamSwitching});
    }

    @Override
    public String toString() {
        return "AdaptationSet{super=" + super.toString() + ", accessibilities=" + this.accessibilities + ", roles=" + this.roles + ", ratings=" + this.ratings + ", viewpoints=" + this.viewpoints + ", contentComponents=" + this.contentComponents + ", baseURLs=" + this.baseURLs + ", segmentBase=" + this.segmentBase + ", segmentList=" + this.segmentList + ", segmentTemplate=" + this.segmentTemplate + ", representations=" + this.representations + ", href='" + this.href + '\'' + ", actuate=" + (Object)((Object)this.actuate) + ", id=" + this.id + ", group=" + this.group + ", lang='" + this.lang + '\'' + ", contentType='" + this.contentType + '\'' + ", par='" + this.par + '\'' + ", minBandwidth=" + this.minBandwidth + ", maxBandwidth=" + this.maxBandwidth + ", minWidth=" + this.minWidth + ", maxWidth=" + this.maxWidth + ", minHeight=" + this.minHeight + ", maxHeight=" + this.maxHeight + ", minFrameRate='" + this.minFrameRate + '\'' + ", maxFrameRate='" + this.maxFrameRate + '\'' + ", segmentAlignment='" + this.segmentAlignment + '\'' + ", subsegmentAlignment='" + this.subsegmentAlignment + '\'' + ", subsegmentStartsWithSAP=" + this.subsegmentStartsWithSAP + ", bitstreamSwitching=" + this.bitstreamSwitching + '}';
    }

    public Builder buildUpon() {
        return this.buildUpon(new Builder().withAccessibilities(this.accessibilities).withRoles(this.roles).withRatings(this.ratings).withViewpoints(this.viewpoints).withContentComponents(this.contentComponents).withBaseURLs(this.baseURLs).withSegmentBase(this.segmentBase).withSegmentList(this.segmentList).withSegmentTemplate(this.segmentTemplate).withRepresentations(this.representations).withHref(this.href).withActuate(this.actuate).withId(this.id).withGroup(this.group).withLang(this.lang).withContentType(this.contentType).withPar(this.par).withMinBandwidth(this.minBandwidth).withMaxBandwidth(this.maxBandwidth).withMinWidth(this.minWidth).withMaxWidth(this.maxWidth).withMinHeight(this.minHeight).withMaxHeight(this.maxHeight).withMinFrameRate(this.minFrameRate).withMaxFrameRate(this.maxFrameRate).withSegmentAlignment(this.segmentAlignment).withSubsegmentAlignment(this.subsegmentAlignment).withSubsegmentStartsWithSAP(this.subsegmentStartsWithSAP).withBitstreamSwitching(this.bitstreamSwitching));
    }

    public static class Builder
    extends RepresentationBase.AbstractBuilder<Builder> {
        private List<Descriptor> accessibilities;
        private List<Descriptor> roles;
        private List<Descriptor> ratings;
        private List<Descriptor> viewpoints;
        private List<ContentComponent> contentComponents;
        private List<BaseURL> baseURLs;
        private SegmentBase segmentBase;
        private SegmentList segmentList;
        private SegmentTemplate segmentTemplate;
        private List<Representation> representations;
        private String href;
        private ActuateType actuate;
        private Long id;
        private Long group;
        private String lang;
        private String contentType;
        private Ratio par;
        private Long minBandwidth;
        private Long maxBandwidth;
        private Long minWidth;
        private Long maxWidth;
        private Long minHeight;
        private Long maxHeight;
        private FrameRate minFrameRate;
        private FrameRate maxFrameRate;
        private String segmentAlignment;
        private String subsegmentAlignment;
        private Long subsegmentStartsWithSAP;
        private Boolean bitstreamSwitching;

        @Override
        Builder getThis() {
            return this;
        }

        public Builder withAccessibilities(List<Descriptor> accessibilities) {
            this.accessibilities = accessibilities;
            return this;
        }

        public Builder withRoles(List<Descriptor> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withRoles(Descriptor role, Descriptor ... moreRoles) {
            this.roles = Utils.varargsToList(role, moreRoles);
            return this;
        }

        public Builder withRoles(Role.Type role, Role.Type ... moreRoles) {
            this.roles = Utils.varargsToList(role, moreRoles).stream().map(Role::new).collect(Collectors.toList());
            return this;
        }

        public Builder withRatings(List<Descriptor> ratings) {
            this.ratings = ratings;
            return this;
        }

        public Builder withViewpoints(List<Descriptor> viewpoints) {
            this.viewpoints = viewpoints;
            return this;
        }

        public Builder withContentComponents(List<ContentComponent> contentComponents) {
            this.contentComponents = contentComponents;
            return this;
        }

        public Builder withBaseURLs(List<BaseURL> baseURLs) {
            this.baseURLs = baseURLs;
            return this;
        }

        public Builder withSegmentBase(SegmentBase segmentBase) {
            this.segmentBase = segmentBase;
            return this;
        }

        public Builder withSegmentList(SegmentList segmentList) {
            this.segmentList = segmentList;
            return this;
        }

        public Builder withSegmentTemplate(SegmentTemplate segmentTemplate) {
            this.segmentTemplate = segmentTemplate;
            return this;
        }

        public Builder withRepresentations(List<Representation> representations) {
            this.representations = representations;
            return this;
        }

        public Builder withRepresentations(Representation representation, Representation ... moreRepresentations) {
            this.representations = Utils.varargsToList(representation, moreRepresentations);
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withActuate(ActuateType actuate) {
            this.actuate = actuate;
            return this;
        }

        public Builder withId(Long id) {
            this.id = id;
            return this;
        }

        public Builder withId(int id) {
            this.id = id;
            return this;
        }

        public Builder withGroup(Long group) {
            this.group = group;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withPar(Ratio par) {
            this.par = par;
            return this;
        }

        public Builder withMinBandwidth(Long minBandwidth) {
            this.minBandwidth = minBandwidth;
            return this;
        }

        public Builder withMaxBandwidth(Long maxBandwidth) {
            this.maxBandwidth = maxBandwidth;
            return this;
        }

        public Builder withMinWidth(Long minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public Builder withMaxWidth(Long maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder withMinHeight(Long minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder withMaxHeight(Long maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public Builder withMinFrameRate(FrameRate minFrameRate) {
            this.minFrameRate = minFrameRate;
            return this;
        }

        public Builder withMaxFrameRate(FrameRate maxFrameRate) {
            this.maxFrameRate = maxFrameRate;
            return this;
        }

        public Builder withSegmentAlignment(String segmentAlignment) {
            this.segmentAlignment = segmentAlignment;
            return this;
        }

        public Builder withSubsegmentAlignment(String subsegmentAlignment) {
            this.subsegmentAlignment = subsegmentAlignment;
            return this;
        }

        public Builder withSubsegmentStartsWithSAP(Long subsegmentStartsWithSAP) {
            this.subsegmentStartsWithSAP = subsegmentStartsWithSAP;
            return this;
        }

        public Builder withBitstreamSwitching(Boolean bitstreamSwitching) {
            this.bitstreamSwitching = bitstreamSwitching;
            return this;
        }

        public AdaptationSet build() {
            return new AdaptationSet(this.framePackings, this.audioChannelConfigurations, this.contentProtections, this.essentialProperties, this.supplementalProperties, this.inbandEventStreams, this.profiles, this.width, this.height, this.sar, this.frameRate, this.audioSamplingRate, this.mimeType, this.segmentProfiles, this.codecs, this.maximumSAPPeriod, this.startWithSAP, this.maxPlayoutRate, this.codingDependency, this.scanType, this.accessibilities, this.roles, this.ratings, this.viewpoints, this.contentComponents, this.baseURLs, this.segmentBase, this.segmentList, this.segmentTemplate, this.representations, this.href, this.actuate, this.id, this.group, this.lang, this.contentType, this.par, this.minBandwidth, this.maxBandwidth, this.minWidth, this.maxWidth, this.minHeight, this.maxHeight, this.minFrameRate, this.maxFrameRate, this.segmentAlignment, this.subsegmentAlignment, this.subsegmentStartsWithSAP, this.bitstreamSwitching);
        }
    }
}

