/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.util.Arrays;

public enum MediaType {
    AUDIO,
    VIDEO,
    TEXT,
    IMAGE,
    OTHER;

    private static final String[] SUPPORTED_APPLICATION_TYPES_AS_TEXT;

    public static MediaType getMediaType(String mediaType) {
        MediaType result = mediaType == null ? OTHER : (mediaType.startsWith("image/") ? IMAGE : (mediaType.startsWith("audio/") ? AUDIO : (mediaType.startsWith("video/") || mediaType.startsWith("application/dash+xml") ? VIDEO : (mediaType.startsWith("text/") || MediaType.isApplicationMediaRepresentingText(mediaType) ? TEXT : OTHER))));
        return result;
    }

    private static boolean mediaTypeMatchesCandidate(String candidateType, String mediaType) {
        return mediaType.equals(candidateType) || !candidateType.contains("+") && mediaType.startsWith(candidateType + "+");
    }

    private static boolean isApplicationMediaRepresentingText(String mediaType) {
        String baseType = mediaType.split(";", 2)[0];
        return Arrays.stream(SUPPORTED_APPLICATION_TYPES_AS_TEXT).anyMatch(candidate -> MediaType.mediaTypeMatchesCandidate(candidate, baseType));
    }

    static {
        SUPPORTED_APPLICATION_TYPES_AS_TEXT = new String[]{"application/xml", "application/rtf", "application/epub", "application/pdf", "application/xhtml+xml"};
    }
}

