/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import com.mongodb.ServerAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class InetAddressUtil<E extends Exception> {
    private final Function<String, E> exceptionCreator;

    public InetAddressUtil(Function<String, E> exceptionCreator) {
        this.exceptionCreator = exceptionCreator;
    }

    public List<InetSocketAddress> getAddressesFromHostsAndPorts(String[] hosts, int[] ports) throws E {
        IntUnaryOperator portGetter;
        if (hosts == null) {
            throw (Exception)this.exceptionCreator.apply("The host array is null.");
        }
        if (ports == null) {
            throw (Exception)this.exceptionCreator.apply("The port array is null.");
        }
        if (ports.length == 1) {
            portGetter = index -> ports[0];
        } else if (hosts.length == ports.length) {
            portGetter = index -> ports[index];
        } else {
            throw (Exception)this.exceptionCreator.apply("The port array length does not match the host array length.");
        }
        return IntStream.range(0, hosts.length).mapToObj(index -> new InetSocketAddress(hosts[index], portGetter.applyAsInt(index))).collect(Collectors.toList());
    }

    public List<ServerAddress> getMongoAddressesFromHostsAndPorts(String[] hosts, int[] ports) throws E {
        return this.getAddressesFromHostsAndPorts(hosts, ports).stream().map(ServerAddress::new).collect(Collectors.toList());
    }
}

