/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.solr;

import eu.europeana.metis.solr.CompoundSolrClient;
import eu.europeana.metis.solr.SolrProperties;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientProvider<E extends Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrClientProvider.class);
    private final SolrProperties<E> settings;

    public SolrClientProvider(SolrProperties<E> properties) {
        this.settings = properties;
    }

    public CompoundSolrClient createSolrClient() throws E {
        LBHttpSolrClient httpSolrClient = this.setUpHttpSolrConnection();
        CloudSolrClient cloudSolrClient = this.settings.hasZookeeperConnection() ? this.setUpCloudSolrConnection(httpSolrClient) : null;
        return new CompoundSolrClient(httpSolrClient, cloudSolrClient);
    }

    private LBHttpSolrClient setUpHttpSolrConnection() throws E {
        CharSequence[] solrHosts = (String[])this.settings.getSolrHosts().stream().map(URI::toString).toArray(String[]::new);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connecting to Solr hosts: [{}]", (Object)String.join((CharSequence)", ", solrHosts));
        }
        return new LBHttpSolrClient.Builder().withBaseSolrUrls((String[])solrHosts).build();
    }

    private CloudSolrClient setUpCloudSolrConnection(LBHttpSolrClient httpSolrClient) throws E {
        Set hosts = this.settings.getZookeeperHosts().stream().map(SolrClientProvider::toCloudSolrClientAddressString).collect(Collectors.toSet());
        String chRoot = this.settings.getZookeeperChroot();
        String defaultCollection = this.settings.getZookeeperDefaultCollection();
        Integer connectionTimeoutInSecs = this.settings.getZookeeperTimeoutInSecs();
        CloudSolrClient.Builder builder = new CloudSolrClient.Builder();
        builder.withZkHost(hosts);
        if (chRoot != null) {
            builder.withZkChroot(chRoot);
        }
        builder.withLBHttpSolrClient(httpSolrClient);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connecting to Zookeeper hosts: [{}] with chRoot [{}] and default connection [{}]. Connection time-out: {}.", String.join((CharSequence)", ", hosts), chRoot, defaultCollection, connectionTimeoutInSecs == null ? "default" : connectionTimeoutInSecs + " seconds");
        }
        CloudSolrClient cloudSolrClient = builder.build();
        cloudSolrClient.setDefaultCollection(defaultCollection);
        if (connectionTimeoutInSecs != null) {
            int timeoutInMillis = (int)Duration.ofSeconds(connectionTimeoutInSecs.intValue()).toMillis();
            cloudSolrClient.setZkConnectTimeout(timeoutInMillis);
            cloudSolrClient.setZkClientTimeout(timeoutInMillis);
        }
        cloudSolrClient.connect();
        return cloudSolrClient;
    }

    static String toCloudSolrClientAddressString(InetSocketAddress address) {
        return address.getHostString() + ":" + address.getPort();
    }
}

