/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import eu.europeana.metis.mongo.MongoProperties;

public class MongoClientProvider<E extends Exception> {
    private final MongoProperties<E> properties;

    public MongoClientProvider(MongoProperties<E> properties) {
        this.properties = properties;
    }

    public MongoClient createMongoClient() throws E {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder().sslEnabled(this.properties.mongoEnableSsl());
        optionsBuilder.readPreference(this.properties.getReadPreferenceValue().getReadPreferenceSupplier().get());
        MongoCredential mongoCredential = this.properties.getMongoCredentials();
        MongoClient mongoClient = mongoCredential == null ? new MongoClient(this.properties.getMongoHosts(), optionsBuilder.build()) : new MongoClient(this.properties.getMongoHosts(), mongoCredential, optionsBuilder.build());
        return mongoClient;
    }
}

