/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.runtime.Network;
import eu.europeana.metis.utils.NetworkUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedLocalhostMongo {
    private static final String DEFAULT_MONGO_HOST = "127.0.0.1";
    private MongodExecutable mongodExecutable;
    private int mongoPort;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedLocalhostMongo.class);

    public void start() {
        if (this.mongodExecutable == null) {
            try {
                this.mongoPort = NetworkUtil.getAvailableLocalPort();
                IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, LOGGER).processOutput(ProcessOutput.getDefaultInstanceSilent()).build();
                MongodStarter runtime = MongodStarter.getInstance(runtimeConfig);
                this.mongodExecutable = (MongodExecutable)runtime.prepare(new MongodConfigBuilder().version(Version.V3_6_5).net(new Net(DEFAULT_MONGO_HOST, this.mongoPort, Network.localhostIsIPv6())).build());
                this.mongodExecutable.start();
            }
            catch (IOException e) {
                LOGGER.error("Exception when starting embedded mongo", e);
            }
        }
    }

    public String getMongoHost() {
        return DEFAULT_MONGO_HOST;
    }

    public int getMongoPort() {
        return this.mongoPort;
    }

    public void stop() {
        this.mongodExecutable.stop();
    }
}

