/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.linkchecking;

import eu.europeana.metis.mediaprocessing.LinkChecker;
import eu.europeana.metis.mediaprocessing.exception.LinkCheckingException;
import eu.europeana.metis.mediaprocessing.http.LinkCheckClient;
import java.io.IOException;

public class LinkCheckerImpl
implements LinkChecker {
    private final LinkCheckClient linkCheckClient;

    public LinkCheckerImpl(int maxRedirectCount) {
        this.linkCheckClient = new LinkCheckClient(maxRedirectCount);
    }

    @Override
    public void performLinkChecking(String resourceEntry) throws LinkCheckingException {
        try {
            this.linkCheckClient.download(resourceEntry);
        }
        catch (IOException | RuntimeException e) {
            throw new LinkCheckingException("Problem while processing " + resourceEntry, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.linkCheckClient.close();
    }
}

