/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.AudioVideoProcessor;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PdfToImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfToImageConverter.class);
    private static String globalGhostScriptCommand;
    private final String ghostScriptCmd;
    private final CommandExecutor commandExecutor;

    PdfToImageConverter(CommandExecutor commandExecutor) throws MediaProcessorException {
        this(commandExecutor, PdfToImageConverter.getGlobalGhostScriptCommand(commandExecutor));
    }

    PdfToImageConverter(CommandExecutor commandExecutor, String ghostScriptCmd) {
        this.ghostScriptCmd = ghostScriptCmd;
        this.commandExecutor = commandExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getGlobalGhostScriptCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        Class<AudioVideoProcessor> clazz = AudioVideoProcessor.class;
        synchronized (AudioVideoProcessor.class) {
            if (globalGhostScriptCommand == null) {
                globalGhostScriptCommand = PdfToImageConverter.discoverGhostScriptCommand(commandExecutor);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return globalGhostScriptCommand;
        }
    }

    static String discoverGhostScriptCommand(CommandExecutor commandExecutor) throws MediaProcessorException {
        String command = "gs";
        String output = commandExecutor.execute(Arrays.asList("gs", "--version"), true, message -> new MediaProcessorException("Error while looking for ghostscript tools: " + message));
        if (!output.startsWith("9.")) {
            throw new MediaProcessorException("Ghostscript 9.x not found.");
        }
        return "gs";
    }

    Path convertToPdf(Path content) throws MediaExtractionException {
        if (content == null) {
            throw new MediaExtractionException("File content is null or file does not exist.");
        }
        Path pdfImage = this.createPdfImageFile();
        try {
            List<String> command = this.createPdfConversionCommand(content, pdfImage);
            this.commandExecutor.execute(command, false, MediaExtractionException::new);
        }
        catch (MediaExtractionException | RuntimeException e) {
            this.removePdfImageFileSilently(pdfImage);
            throw e;
        }
        return pdfImage;
    }

    void removePdfImageFileSilently(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            LOGGER.warn("Could not remove PDF image: {}", (Object)file.toAbsolutePath(), (Object)e);
        }
    }

    Path createPdfImageFile() throws MediaExtractionException {
        try {
            return Files.createTempFile("metis_pdf_image_", null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not create temporary file.", e);
        }
    }

    List<String> createPdfConversionCommand(Path inputFile, Path outputFile) {
        return Arrays.asList(this.ghostScriptCmd, "-q", "-dQUIET", "-dSAFER", "-dBATCH", "-dNOPAUSE", "-dNOPROMPT", "-dMaxBitmap=500000000", "-dAlignToPixels=0", "-dGridFitTT=2", "-sDEVICE=pngalpha", "-dTextAlphaBits=4", "-dGraphicsAlphaBits=4", "-r72x72", "-dFirstPage=1", "-dLastPage=1", "-sOutputFile=" + outputFile.toAbsolutePath().toString(), "-f" + inputFile.toAbsolutePath().toString());
    }
}

