/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing;

import eu.europeana.metis.mediaprocessing.LinkChecker;
import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.MediaExtractorImpl;
import eu.europeana.metis.mediaprocessing.linkchecking.LinkCheckerImpl;

public class MediaProcessorFactory {
    public static final int DEFAULT_MAX_REDIRECT_COUNT = 3;
    public static final int DEFAULT_THUMBNAIL_GENERATE_TIMEOUT = 20;
    public static final int DEFAULT_AUDIO_VIDEO_PROBE_TIMEOUT = 60;
    public static final int DEFAULT_RESOURCE_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_RESOURCE_RESPONSE_TIMEOUT = 20000;
    public static final int DEFAULT_RESOURCE_DOWNLOAD_TIMEOUT = 600000;
    private int maxRedirectCount = 3;
    private int thumbnailGenerateTimeout = 20;
    private int audioVideoProbeTimeout = 60;
    private int resourceConnectTimeout = 10000;
    private int resourceResponseTimeout = 20000;
    private int resourceDownloadTimeout = 600000;

    public void setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = maxRedirectCount < 0 ? 3 : maxRedirectCount;
    }

    public void setThumbnailGenerateTimeout(int thumbnailGenerateTimeout) {
        this.thumbnailGenerateTimeout = thumbnailGenerateTimeout < 1 ? 20 : thumbnailGenerateTimeout;
    }

    public void setAudioVideoProbeTimeout(int audioVideoProbeTimeout) {
        this.audioVideoProbeTimeout = audioVideoProbeTimeout < 1 ? 60 : audioVideoProbeTimeout;
    }

    public void setResourceConnectTimeout(int resourceConnectTimeout) {
        this.resourceConnectTimeout = resourceConnectTimeout < 1 ? 10000 : resourceConnectTimeout;
    }

    public void setResourceResponseTimeout(int resourceResponseTimeout) {
        this.resourceResponseTimeout = resourceResponseTimeout < 1 ? 20000 : resourceResponseTimeout;
    }

    @Deprecated
    public void setResourceSocketTimeout(int resourceSocketTimeout) {
        this.setResourceResponseTimeout(resourceSocketTimeout);
    }

    public void setResourceDownloadTimeout(int resourceDownloadTimeout) {
        this.resourceDownloadTimeout = resourceDownloadTimeout < 1 ? 600000 : resourceDownloadTimeout;
    }

    public MediaExtractor createMediaExtractor() throws MediaProcessorException {
        return new MediaExtractorImpl(this.maxRedirectCount, this.thumbnailGenerateTimeout, this.audioVideoProbeTimeout, this.resourceConnectTimeout, this.resourceResponseTimeout, this.resourceDownloadTimeout);
    }

    public LinkChecker createLinkChecker() throws MediaProcessorException {
        return new LinkCheckerImpl(this.maxRedirectCount);
    }
}

