/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class TasksByStateDAO
extends CassandraDAO {
    private PreparedStatement insertStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement findTasksInGivenState;
    private PreparedStatement listAllInUseTopicsForTopology;
    private PreparedStatement findTask;

    public TasksByStateDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO tasks_by_task_state(state,topology_name,task_id,application_id,topic_name,start_time) VALUES (?,?,?,?,?,?)");
        this.deleteStatement = this.dbService.getSession().prepare("DELETE FROM tasks_by_task_state WHERE state = ? AND topology_name = ? AND task_id = ?");
        this.findTask = this.dbService.getSession().prepare("SELECT * FROM tasks_by_task_state WHERE state = ? AND topology_name = ? AND task_id = ?");
        this.findTasksInGivenState = this.dbService.getSession().prepare("SELECT * FROM tasks_by_task_state WHERE state = ?");
        this.listAllInUseTopicsForTopology = this.dbService.getSession().prepare("SELECT topic_name FROM tasks_by_task_state WHERE state IN ? AND topology_name = ?");
    }

    private void insert(Optional<String> oldState, String state, String topologyName, long taskId, String applicationId, String topicName, Date startTime) throws NoHostAvailableException, QueryExecutionException {
        if (oldState.isPresent() && !oldState.equals(state)) {
            this.delete(oldState.get(), topologyName, taskId);
        }
        this.dbService.getSession().execute(this.insertStatement.bind(state, topologyName, taskId, applicationId, topicName, startTime));
    }

    private void delete(String state, String topologyName, long taskId) {
        this.dbService.getSession().execute(this.deleteStatement.bind(state, topologyName, taskId));
    }

    public void insert(Optional<String> oldState, String state, String topologyName, long taskId, String applicationId, String topicName) {
        this.insert(oldState, state, topologyName, taskId, applicationId, topicName, new Date());
    }

    public void updateTask(String topologyName, long taskId, String oldState, String newState) {
        if (oldState.equals(newState)) {
            return;
        }
        Row oldTask = this.dbService.getSession().execute(this.findTask.bind(oldState, topologyName, taskId)).one();
        String applicationId = "";
        String topicName = "";
        Date startTime = null;
        if (oldTask != null) {
            applicationId = oldTask.getString("application_id");
            topicName = oldTask.getString("topic_name");
            startTime = oldTask.getDate("start_time");
        }
        this.insert(Optional.of(oldState), newState, topologyName, taskId, applicationId, topicName, startTime);
    }

    public List<TaskInfo> findTasksInGivenState(TaskState taskState) throws NoHostAvailableException, QueryExecutionException {
        ArrayList<TaskInfo> results = new ArrayList<TaskInfo>();
        ResultSet rs = this.dbService.getSession().execute(this.findTasksInGivenState.bind(taskState.toString()));
        for (Row row : rs) {
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setState(TaskState.PROCESSING_BY_REST_APPLICATION);
            taskInfo.setTopologyName(row.getString("state"));
            taskInfo.setId(row.getLong("task_id"));
            taskInfo.setOwnerId(row.getString("application_id"));
            results.add(taskInfo);
        }
        return results;
    }

    public List<String> listAllInUseTopicsFor(String topologyName) {
        ArrayList<String> results = new ArrayList<String>();
        ResultSet rs = this.dbService.getSession().execute(this.listAllInUseTopicsForTopology.bind(Arrays.asList(TaskState.PROCESSING_BY_REST_APPLICATION.toString(), TaskState.QUEUED.toString()), topologyName));
        for (Row row : rs) {
            results.add(row.getString("topic_name"));
        }
        return results;
    }
}

