/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.common.model.dps.TaskStateInfo;
import eu.europeana.cloud.service.dps.exception.TaskInfoDoesNotExistException;
import eu.europeana.cloud.service.dps.storm.spouts.kafka.SubmitTaskParameters;
import eu.europeana.cloud.service.dps.storm.utils.CassandraTaskInfoDAO;
import eu.europeana.cloud.service.dps.storm.utils.TasksByStateDAO;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatusUpdater.class);
    private static TaskStatusUpdater instance;
    private CassandraTaskInfoDAO taskInfoDAO;
    private TasksByStateDAO tasksByStateDAO;
    private String applicationIdentifier;

    public TaskStatusUpdater(CassandraTaskInfoDAO taskInfoDAO, TasksByStateDAO tasksByStateDAO, String applicationIdentifier) {
        this.taskInfoDAO = taskInfoDAO;
        this.tasksByStateDAO = tasksByStateDAO;
        this.applicationIdentifier = applicationIdentifier;
    }

    public static synchronized TaskStatusUpdater getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new TaskStatusUpdater(CassandraTaskInfoDAO.getInstance(cassandra), new TasksByStateDAO(cassandra), "");
        }
        return instance;
    }

    public TaskInfo searchById(long taskId) throws NoHostAvailableException, QueryExecutionException, TaskInfoDoesNotExistException {
        return this.taskInfoDAO.searchById(taskId);
    }

    public void insertTask(SubmitTaskParameters parameters) {
        long taskId = parameters.getTask().getTaskId();
        String topologyName = parameters.getTopologyName();
        String state = parameters.getStatus().toString();
        this.tasksByStateDAO.insert(this.taskInfoDAO.findTaskStatus(taskId), state, topologyName, taskId, this.applicationIdentifier, parameters.getTopicName());
        this.taskInfoDAO.insert(taskId, topologyName, parameters.getExpectedSize(), 0, state, parameters.getInfo(), parameters.getSentTime(), null, null, 0, parameters.getTaskJSON());
    }

    public void updateTask(long taskId, String info, String state, Date startDate) throws NoHostAvailableException, QueryExecutionException {
        this.updateTasksByTaskStateTable(taskId, state);
        this.taskInfoDAO.updateTask(taskId, info, state, startDate);
    }

    public void setTaskCompletelyProcessed(long taskId, String info) throws NoHostAvailableException, QueryExecutionException {
        this.updateTasksByTaskStateTable(taskId, TaskState.PROCESSED.toString());
        this.taskInfoDAO.setTaskCompletelyProcessed(taskId, info);
    }

    public void setTaskDropped(long taskId, String info) throws NoHostAvailableException, QueryExecutionException {
        this.updateTasksByTaskStateTable(taskId, TaskState.DROPPED.toString());
        this.taskInfoDAO.setTaskDropped(taskId, info);
    }

    public void setUpdateExpectedSize(long taskId, int expectedSize) throws NoHostAvailableException, QueryExecutionException {
        this.taskInfoDAO.setUpdateExpectedSize(taskId, expectedSize);
    }

    public void endTask(long taskId, int processeFilesCount, int errors, String info, String state, Date finishDate) throws NoHostAvailableException, QueryExecutionException {
        this.updateTasksByTaskStateTable(taskId, state);
        this.taskInfoDAO.endTask(taskId, processeFilesCount, errors, info, state, finishDate);
    }

    public void setUpdateProcessedFiles(long taskId, int processedFilesCount, int errors) throws NoHostAvailableException, QueryExecutionException {
        this.taskInfoDAO.setUpdateProcessedFiles(taskId, processedFilesCount, errors);
    }

    public void updateStatusExpectedSize(long taskId, String state, int expectedSize) throws NoHostAvailableException, QueryExecutionException {
        LOGGER.info("Updating task {} expected size to: {}", (Object)taskId, (Object)expectedSize);
        this.updateTasksByTaskStateTable(taskId, state);
        this.taskInfoDAO.updateStatusExpectedSize(taskId, state, expectedSize);
    }

    private void updateTasksByTaskStateTable(long taskId, String newState) {
        Optional<TaskStateInfo> oldTask = this.taskInfoDAO.findTaskStateInfo(taskId);
        if (oldTask.isPresent()) {
            this.tasksByStateDAO.updateTask(oldTask.get().getTopologyName(), taskId, oldTask.get().getState(), newState);
        }
    }
}

