/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(Retriever.class);
    private static final int DEFAULT_RETRIES = 3;
    private static final int SLEEP_TIME = 5000;

    public static void retryOnError3Times(String errorMessage, Runnable runnable) {
        Retriever.retryOnError3Times(errorMessage, () -> {
            runnable.run();
            return null;
        });
    }

    public static <V, E extends Exception> V retryOnError3Times(String errorMessage, Callable<V> callable) throws E {
        int retries = 3;
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn(errorMessage + " Retries Left{} ", (Object)retries);
                    Retriever.waitForSpecificTime(5000);
                    continue;
                }
                LOGGER.error(errorMessage);
                throw e;
            }
            break;
        }
    }

    public static void waitForSpecificTime(int milliSecond) {
        try {
            Thread.sleep(milliSecond);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Stop waiting for retry beacase interrupted flag set on Thread!", e);
        }
    }
}

