/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.ProcessedRecord;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;

public class ProcessedRecordsDAO
extends CassandraDAO {
    private PreparedStatement insertStatement;
    private PreparedStatement selectByPrimaryKeyStatement;
    private static ProcessedRecordsDAO instance = null;

    public static synchronized ProcessedRecordsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new ProcessedRecordsDAO(cassandra);
        }
        return instance;
    }

    public ProcessedRecordsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO processed_records(task_id,src_identifier,dst_identifier,topology_name,state,info_text,additional_informations) VALUES (?,?,?,?,?,?,?)");
        this.selectByPrimaryKeyStatement = this.dbService.getSession().prepare("SELECT dst_identifier,topology_name,state,info_text,additional_informations FROM processed_records WHERE task_id = ? AND src_identifier = ?");
    }

    public void insert(long taskId, String srcResource, String dstResource, String topologyName, String state, String infoText, String additionalInformations) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute(this.insertStatement.bind(taskId, srcResource, dstResource, topologyName, state, infoText, additionalInformations));
    }

    public ProcessedRecord selectByPrimaryKey(long taskId, String srcIdentifier) throws NoHostAvailableException, QueryExecutionException {
        ProcessedRecord result = null;
        ResultSet rs = this.dbService.getSession().execute(this.selectByPrimaryKeyStatement.bind(taskId, srcIdentifier));
        Row row = rs.one();
        if (row != null) {
            result = ProcessedRecord.builder().taskId(taskId).srcIdentifier(srcIdentifier).dstIdentifier(row.getString("dst_identifier")).topologyName(row.getString("topology_name")).state(RecordState.valueOf(row.getString("state"))).infoText(row.getString("info_text")).additionalInformations(row.getString("additional_informations")).build();
        }
        return result;
    }
}

