/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CassandraSubTaskInfoDAO
extends CassandraDAO {
    private PreparedStatement subtaskSearchStatement;
    private PreparedStatement subtaskInsertStatement;
    private PreparedStatement processedFilesCountStatement;
    private PreparedStatement removeNotificationsByTaskId;
    private static CassandraSubTaskInfoDAO instance = null;

    public static synchronized CassandraSubTaskInfoDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraSubTaskInfoDAO(cassandra);
        }
        return instance;
    }

    public CassandraSubTaskInfoDAO(CassandraConnectionProvider dbService) {
        super(dbService);
    }

    @Override
    void prepareStatements() {
        this.subtaskInsertStatement = this.dbService.getSession().prepare("INSERT INTO notifications(resource_num,task_id,topology_name,resource,state,info_text,additional_informations,result_resource) VALUES (?,?,?,?,?,?,?,?)");
        this.subtaskInsertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.subtaskSearchStatement = this.dbService.getSession().prepare("SELECT * FROM notifications WHERE task_id = ?");
        this.subtaskSearchStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.processedFilesCountStatement = this.dbService.getSession().prepare("SELECT resource_num FROM notifications WHERE task_id = ? limit 1");
        this.processedFilesCountStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeNotificationsByTaskId = this.dbService.getSession().prepare("delete from notifications WHERE task_id = ?");
    }

    public void insert(int resourceNum, long taskId, String topologyName, String resource, String state, String infoTxt, String additionalInformations, String resultResource) throws NoHostAvailableException, QueryExecutionException {
        this.dbService.getSession().execute(this.subtaskInsertStatement.bind(resourceNum, taskId, topologyName, resource, state, infoTxt, additionalInformations, resultResource));
    }

    public List<SubTaskInfo> searchById(long taskId) throws NoHostAvailableException, QueryExecutionException {
        ResultSet rs = this.dbService.getSession().execute(this.subtaskSearchStatement.bind(taskId));
        ArrayList<SubTaskInfo> result = new ArrayList<SubTaskInfo>();
        for (Row row : rs.all()) {
            result.add(new SubTaskInfo(row.getInt("resource_num"), row.getString("resource"), RecordState.valueOf(row.getString("state")), row.getString("info_text"), row.getString("additional_informations"), row.getString("result_resource")));
        }
        return result;
    }

    public int getProcessedFilesCount(long taskId) {
        ResultSet rs = this.dbService.getSession().execute(this.processedFilesCountStatement.bind(taskId));
        Iterator<Row> iterator = rs.iterator();
        if (iterator.hasNext()) {
            Row row = iterator.next();
            return row.getInt("resource_num");
        }
        return 0;
    }

    public void removeNotifications(long taskId) {
        this.dbService.getSession().execute(this.removeNotificationsByTaskId.bind(taskId));
    }
}

