/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.utils;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.gson.Gson;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import eu.europeana.cloud.common.model.dps.NodeReport;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.service.dps.storm.utils.CassandraAttributeStatisticsDAO;
import eu.europeana.cloud.service.dps.storm.utils.CassandraDAO;
import java.util.ArrayList;
import java.util.List;

public class CassandraNodeStatisticsDAO
extends CassandraDAO {
    public static final int ELEMETNS_SAMPLE_MAX_SIZE = 100;
    public static final int ATTRIBUTES_SAMPLE_MAX_SIZE = 25;
    private final Gson gson = new Gson();
    private PreparedStatement updateStatement;
    private PreparedStatement updateNodeStatement;
    private PreparedStatement searchByParentStatement;
    private PreparedStatement searchGeneralStatistcsByTaskIdStatement;
    private PreparedStatement removeGeneralStatisticsStatement;
    private PreparedStatement searchByNodeStatement;
    private PreparedStatement searchByAttributeStatement;
    private PreparedStatement searchNodesStatement;
    private PreparedStatement searchNodesStatementAll;
    private PreparedStatement deleteNodesStatistcsStatement;
    private PreparedStatement getStatisticsReportStatement;
    private PreparedStatement removeStatisticsReportStatement;
    private PreparedStatement checkStatisticsReportStatement;
    private PreparedStatement storeStatisticsReportStatement;
    private CassandraAttributeStatisticsDAO cassandraAttributeStatisticsDAO;
    private static CassandraNodeStatisticsDAO instance = null;

    public static synchronized CassandraNodeStatisticsDAO getInstance(CassandraConnectionProvider cassandra) {
        if (instance == null) {
            instance = new CassandraNodeStatisticsDAO(cassandra);
        }
        return instance;
    }

    public CassandraNodeStatisticsDAO(CassandraConnectionProvider dbService) {
        super(dbService);
        this.cassandraAttributeStatisticsDAO = CassandraAttributeStatisticsDAO.getInstance(dbService);
    }

    @Override
    void prepareStatements() {
        this.updateStatement = this.dbService.getSession().prepare("UPDATE general_statistics SET occurrence = occurrence + 1 WHERE task_id = ? AND parent_xpath = ? AND node_xpath = ?");
        this.updateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateNodeStatement = this.dbService.getSession().prepare("UPDATE node_statistics SET occurrence = occurrence + ? WHERE task_id = ? AND node_xpath = ? AND node_value = ?");
        this.updateNodeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchGeneralStatistcsByTaskIdStatement = this.dbService.getSession().prepare("SELECT * FROM general_statistics WHERE task_id = ?");
        this.searchGeneralStatistcsByTaskIdStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeGeneralStatisticsStatement = this.dbService.getSession().prepare("DELETE  FROM general_statistics WHERE task_id = ?");
        this.removeGeneralStatisticsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByParentStatement = this.dbService.getSession().prepare("SELECT * FROM general_statistics WHERE task_id = ? AND parent_xpath = ?");
        this.searchByParentStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByNodeStatement = this.dbService.getSession().prepare("SELECT * FROM general_statistics WHERE task_id = ? AND parent_xpath = ? AND node_xpath = ?");
        this.searchByNodeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchNodesStatement = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ? limit ?");
        this.searchNodesStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchNodesStatementAll = this.dbService.getSession().prepare("SELECT * FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
        this.searchNodesStatementAll.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteNodesStatistcsStatement = this.dbService.getSession().prepare("DELETE  FROM node_statistics WHERE task_id = ? AND node_xpath = ?");
        this.deleteNodesStatistcsStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByAttributeStatement = this.dbService.getSession().prepare("SELECT * FROM attribute_statistics WHERE task_id = ? AND node_xpath = ? AND node_value = ? limit ?");
        this.searchByAttributeStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.checkStatisticsReportStatement = this.dbService.getSession().prepare("SELECT task_id FROM statistics_reports WHERE task_id = ?");
        this.checkStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.getStatisticsReportStatement = this.dbService.getSession().prepare("SELECT blobastext(report_data) FROM statistics_reports WHERE task_id = ?");
        this.getStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.removeStatisticsReportStatement = this.dbService.getSession().prepare("DELETE  FROM statistics_reports WHERE task_id = ?");
        this.removeStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.storeStatisticsReportStatement = this.dbService.getSession().prepare("INSERT INTO statistics_reports (task_id,report_data) VALUES (?,textasblob(?))");
        this.storeStatisticsReportStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public void insertNodeStatistics(long taskId, List<NodeStatistics> nodes) {
        for (NodeStatistics nodeStatistics : nodes) {
            this.insertNodeStatistics(taskId, nodeStatistics);
        }
    }

    public void insertNodeStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.updateGeneralStatistics(taskId, nodeStatistics);
        if (nodeStatistics.getValue() != null) {
            this.updateNodeStatistics(taskId, nodeStatistics);
        }
        if (nodeStatistics.hasAttributes()) {
            this.cassandraAttributeStatisticsDAO.insertAttributeStatistics(taskId, nodeStatistics.getXpath(), nodeStatistics.getValue(), nodeStatistics.getAttributesStatistics());
        }
    }

    private void updateNodeStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute(this.updateNodeStatement.bind(nodeStatistics.getOccurrence(), taskId, nodeStatistics.getXpath(), nodeStatistics.getValue()));
    }

    private void updateGeneralStatistics(long taskId, NodeStatistics nodeStatistics) {
        this.dbService.getSession().execute(this.updateStatement.bind(taskId, nodeStatistics.getParentXpath(), nodeStatistics.getXpath()));
    }

    public List<NodeStatistics> getNodeStatistics(long taskId) {
        ResultSet rs = this.dbService.getSession().execute(this.searchGeneralStatistcsByTaskIdStatement.bind(taskId));
        ArrayList<NodeStatistics> result = new ArrayList<NodeStatistics>();
        while (rs.iterator().hasNext()) {
            String nodeXpath;
            Row row = rs.one();
            String parentXpath = row.getString("parent_xpath");
            List<NodeStatistics> nodeStatistics = this.retrieveNodeStatistics(taskId, parentXpath, nodeXpath = row.getString("node_xpath"));
            if (nodeStatistics.isEmpty()) {
                Long occurrence = row.getLong("occurrence");
                NodeStatistics node = new NodeStatistics(parentXpath, nodeXpath, "", occurrence);
                node.setAttributesStatistics(this.cassandraAttributeStatisticsDAO.getAttributeStatistics(taskId, nodeXpath, ""));
            }
            result.addAll(nodeStatistics);
        }
        return result;
    }

    private List<NodeStatistics> retrieveNodeStatistics(long taskId, String parentXpath, String nodeXpath) {
        ArrayList<NodeStatistics> result = new ArrayList<NodeStatistics>();
        ResultSet rs = this.dbService.getSession().execute(this.searchNodesStatement.bind(taskId, nodeXpath, 2));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            NodeStatistics nodeStatistics = new NodeStatistics(parentXpath, nodeXpath, row.getString("node_value"), row.getLong("occurrence"));
            nodeStatistics.setAttributesStatistics(this.cassandraAttributeStatisticsDAO.getAttributeStatistics(taskId, nodeXpath, nodeStatistics.getValue()));
            result.add(nodeStatistics);
        }
        return result;
    }

    public List<NodeStatistics> getNodeStatistics(long taskId, String parentXpath, String nodeXpath) {
        BoundStatement bs = nodeXpath.isEmpty() ? this.searchByParentStatement.bind(taskId, parentXpath) : this.searchByNodeStatement.bind(taskId, parentXpath, nodeXpath);
        ResultSet rs = this.dbService.getSession().execute(bs);
        ArrayList<NodeStatistics> result = new ArrayList<NodeStatistics>();
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            result.addAll(this.retrieveNodeStatistics(taskId, row.getString("parent_xpath"), row.getString("node_xpath")));
        }
        return result;
    }

    public boolean isReportStored(long taskId) {
        BoundStatement bs = this.checkStatisticsReportStatement.bind(taskId);
        ResultSet rs = this.dbService.getSession().execute(bs);
        return rs.iterator().hasNext();
    }

    public void storeStatisticsReport(long taskId, StatisticsReport report) {
        if (this.isReportStored(taskId)) {
            return;
        }
        String reportSerialized = this.gson.toJson(report);
        if (reportSerialized != null) {
            BoundStatement bs = this.storeStatisticsReportStatement.bind(taskId, reportSerialized);
            this.dbService.getSession().execute(bs);
        }
    }

    public StatisticsReport getStatisticsReport(long taskId) {
        BoundStatement bs = this.getStatisticsReportStatement.bind(taskId);
        ResultSet rs = this.dbService.getSession().execute(bs);
        if (rs.iterator().hasNext()) {
            Row row = rs.one();
            String report = row.getString(0);
            return this.gson.fromJson(report, StatisticsReport.class);
        }
        return null;
    }

    public List<NodeReport> getElementReport(long taskId, String nodeXpath) {
        ArrayList<NodeReport> result = new ArrayList<NodeReport>();
        ResultSet rs = this.dbService.getSession().execute(this.searchNodesStatement.bind(taskId, nodeXpath, 100));
        while (rs.iterator().hasNext()) {
            Row elementRow = rs.one();
            String elementValue = elementRow.getString("node_value");
            List<AttributeStatistics> attributeStatistics = this.getAttributesStatistics(taskId, nodeXpath, elementValue);
            NodeReport nodeValues = new NodeReport(elementValue, elementRow.getLong("occurrence"), attributeStatistics);
            result.add(nodeValues);
        }
        return result;
    }

    public void removeStatistics(long taskId) {
        this.removeGeneralStatistics(taskId);
        this.dbService.getSession().execute(this.removeStatisticsReportStatement.bind(taskId));
    }

    public void removeGeneralStatistics(long taskId) {
        ResultSet rs = this.dbService.getSession().execute(this.searchGeneralStatistcsByTaskIdStatement.bind(taskId));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            String nodeXpath = row.getString("node_xpath");
            this.removeNodeStatistics(taskId, nodeXpath);
        }
        this.dbService.getSession().execute(this.removeGeneralStatisticsStatement.bind(taskId));
    }

    private void removeNodeStatistics(long taskId, String nodeXpath) {
        ResultSet rs = this.dbService.getSession().execute(this.searchNodesStatementAll.bind(taskId, nodeXpath));
        while (rs.iterator().hasNext()) {
            Row row = rs.one();
            this.cassandraAttributeStatisticsDAO.removeAttributeStatistics(taskId, nodeXpath, row.getString("node_value"));
        }
        this.dbService.getSession().execute(this.deleteNodesStatistcsStatement.bind(taskId, nodeXpath));
    }

    private List<AttributeStatistics> getAttributesStatistics(long taskId, String nodeXpath, String elementValue) {
        ArrayList<AttributeStatistics> attributeStatistics = new ArrayList<AttributeStatistics>();
        ResultSet attributeRs = this.dbService.getSession().execute(this.searchByAttributeStatement.bind(taskId, nodeXpath, elementValue, 25));
        while (attributeRs.iterator().hasNext()) {
            Row attributeRow = attributeRs.one();
            attributeStatistics.add(new AttributeStatistics(attributeRow.getString("attribute_name"), attributeRow.getString("attribute_value"), attributeRow.getLong("occurrence")));
        }
        return attributeStatistics;
    }
}

