/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spouts.kafka;

import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.DpsTask;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class SubmitTaskParameters {
    private Date sentTime;
    private int expectedSize;
    private TaskState status;
    private String info;
    private DpsTask task;
    private String topologyName;
    private String topicName;
    private final boolean restart;
    private String taskJSON;
    private AtomicInteger sentRecordsCounter;

    public int incrementAndGetSentRecordCounter() {
        return this.sentRecordsCounter.incrementAndGet();
    }

    SubmitTaskParameters(Date sentTime, int expectedSize, TaskState status, String info, DpsTask task, String topologyName, String topicName, boolean restart, String taskJSON, AtomicInteger sentRecordsCounter) {
        this.sentTime = sentTime;
        this.expectedSize = expectedSize;
        this.status = status;
        this.info = info;
        this.task = task;
        this.topologyName = topologyName;
        this.topicName = topicName;
        this.restart = restart;
        this.taskJSON = taskJSON;
        this.sentRecordsCounter = sentRecordsCounter;
    }

    public static SubmitTaskParametersBuilder builder() {
        return new SubmitTaskParametersBuilder();
    }

    public Date getSentTime() {
        return this.sentTime;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public TaskState getStatus() {
        return this.status;
    }

    public String getInfo() {
        return this.info;
    }

    public DpsTask getTask() {
        return this.task;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean isRestart() {
        return this.restart;
    }

    public String getTaskJSON() {
        return this.taskJSON;
    }

    public void setSentTime(Date sentTime) {
        this.sentTime = sentTime;
    }

    public void setExpectedSize(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public void setStatus(TaskState status) {
        this.status = status;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setTask(DpsTask task) {
        this.task = task;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setTaskJSON(String taskJSON) {
        this.taskJSON = taskJSON;
    }

    public String toString() {
        return "SubmitTaskParameters(sentTime=" + this.getSentTime() + ", expectedSize=" + this.getExpectedSize() + ", status=" + (Object)((Object)this.getStatus()) + ", info=" + this.getInfo() + ", task=" + this.getTask() + ", topologyName=" + this.getTopologyName() + ", topicName=" + this.getTopicName() + ", restart=" + this.isRestart() + ", taskJSON=" + this.getTaskJSON() + ", sentRecordsCounter=" + this.sentRecordsCounter + ")";
    }

    public static class SubmitTaskParametersBuilder {
        private Date sentTime;
        private TaskState status;
        private String info;
        private DpsTask task;
        private String topologyName;
        private String topicName;
        private boolean restart;
        private String taskJSON;
        private int expectedSize = 0;
        private AtomicInteger sentRecordsCounter = new AtomicInteger();

        SubmitTaskParametersBuilder() {
        }

        public SubmitTaskParametersBuilder sentTime(Date sentTime) {
            this.sentTime = sentTime;
            return this;
        }

        public SubmitTaskParametersBuilder expectedSize(int expectedSize) {
            this.expectedSize = expectedSize;
            return this;
        }

        public SubmitTaskParametersBuilder status(TaskState status) {
            this.status = status;
            return this;
        }

        public SubmitTaskParametersBuilder info(String info) {
            this.info = info;
            return this;
        }

        public SubmitTaskParametersBuilder task(DpsTask task) {
            this.task = task;
            return this;
        }

        public SubmitTaskParametersBuilder topologyName(String topologyName) {
            this.topologyName = topologyName;
            return this;
        }

        public SubmitTaskParametersBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public SubmitTaskParametersBuilder restart(boolean restart) {
            this.restart = restart;
            return this;
        }

        public SubmitTaskParametersBuilder taskJSON(String taskJSON) {
            this.taskJSON = taskJSON;
            return this;
        }

        public SubmitTaskParametersBuilder sentRecordsCounter(AtomicInteger sentRecordsCounter) {
            this.sentRecordsCounter = sentRecordsCounter;
            return this;
        }

        public SubmitTaskParameters build() {
            return new SubmitTaskParameters(this.sentTime, this.expectedSize, this.status, this.info, this.task, this.topologyName, this.topicName, this.restart, this.taskJSON, this.sentRecordsCounter);
        }

        public String toString() {
            return "SubmitTaskParameters.SubmitTaskParametersBuilder(sentTime=" + this.sentTime + ", expectedSize=" + this.expectedSize + ", status=" + (Object)((Object)this.status) + ", info=" + this.info + ", task=" + this.task + ", topologyName=" + this.topologyName + ", topicName=" + this.topicName + ", restart=" + this.restart + ", taskJSON=" + this.taskJSON + ", sentRecordsCounter=" + this.sentRecordsCounter + ")";
        }
    }
}

