/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spouts.kafka;

import eu.europeana.cloud.common.model.CloudIdAndTimestampResponse;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.CloudTagsResponse;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.RepresentationIterator;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.utils.Retriever;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCSReader
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MCSReader.class);
    private final DataSetServiceClient dataSetServiceClient;
    private final FileServiceClient fileServiceClient;
    private final RecordServiceClient recordServiceClient;

    public MCSReader(String mcsClientURL, String authorizationHeader) {
        this.dataSetServiceClient = new DataSetServiceClient(mcsClientURL, authorizationHeader);
        this.recordServiceClient = new RecordServiceClient(mcsClientURL, authorizationHeader);
        this.fileServiceClient = new FileServiceClient(mcsClientURL, authorizationHeader);
    }

    public ResultSlice<CloudIdAndTimestampResponse> getLatestDataSetCloudIdByRepresentationAndRevisionChunk(String representationName, String revisionName, String revisionProvider, String datasetName, String datasetProvider, String startFrom) throws DriverException {
        return Retriever.retryOnError3Times("Error while getting slice of latest cloud Id from data set.", () -> {
            ResultSlice<CloudIdAndTimestampResponse> resultSlice = this.dataSetServiceClient.getLatestDataSetCloudIdByRepresentationAndRevisionChunk(datasetName, datasetProvider, revisionProvider, revisionName, representationName, false, startFrom);
            if (resultSlice == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            return resultSlice;
        });
    }

    public ResultSlice<CloudTagsResponse> getDataSetRevisionsChunk(String representationName, String revisionName, String revisionProvider, String revisionTimestamp, String datasetProvider, String datasetName, String startFrom) throws DriverException {
        return Retriever.retryOnError3Times("Error while getting Revisions from data set.", () -> {
            ResultSlice<CloudTagsResponse> resultSlice = this.dataSetServiceClient.getDataSetRevisionsChunk(datasetProvider, datasetName, representationName, revisionName, revisionProvider, revisionTimestamp, startFrom, null);
            if (resultSlice == null || resultSlice.getResults() == null) {
                throw new DriverException("Getting cloud ids and revision tags: result chunk obtained but is empty.");
            }
            return resultSlice;
        });
    }

    public List<Representation> getRepresentationsByRevision(String representationName, String revisionName, String revisionProvider, String revisionTimestamp, String responseCloudId) {
        return Retriever.retryOnError3Times("Error while getting representation revision.", () -> this.recordServiceClient.getRepresentationsByRevision(responseCloudId, representationName, revisionName, revisionProvider, revisionTimestamp));
    }

    public RepresentationIterator getRepresentationsOfEntireDataset(UrlParser urlParser) {
        return this.dataSetServiceClient.getRepresentationIterator(urlParser.getPart(UrlPart.DATA_PROVIDERS), urlParser.getPart(UrlPart.DATA_SETS));
    }

    @Override
    public void close() {
        this.dataSetServiceClient.close();
        this.recordServiceClient.close();
        this.fileServiceClient.close();
    }
}

