/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spout;

import eu.europeana.cloud.common.model.CloudIdAndTimestampResponse;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.spout.QueueFillerJobForRevision;
import eu.europeana.cloud.service.dps.storm.utils.DateHelper;
import eu.europeana.cloud.service.dps.storm.utils.TaskStatusChecker;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.storm.spout.SpoutOutputCollector;

public class QueueFillerForLatestRevisionJob
extends QueueFillerJobForRevision {
    private List<CloudIdAndTimestampResponse> cloudIdAndTimestampResponseList;

    public QueueFillerForLatestRevisionJob(FileServiceClient fileServiceClient, RecordServiceClient recordServiceClient, SpoutOutputCollector collector, TaskStatusChecker taskStatusChecker, ArrayBlockingQueue<StormTaskTuple> tuplesWithFileUrls, StormTaskTuple stormTaskTuple, String representationName, String revisionName, String revisionProvider, List<CloudIdAndTimestampResponse> cloudIdAndTimestampResponseList) {
        super(recordServiceClient, fileServiceClient, representationName, stormTaskTuple, revisionName, revisionProvider, taskStatusChecker, collector, tuplesWithFileUrls);
        this.cloudIdAndTimestampResponseList = cloudIdAndTimestampResponseList;
    }

    @Override
    public int fillTheQueue() throws MCSException {
        int count = 0;
        for (CloudIdAndTimestampResponse cloudIdAndTimestampResponse : this.cloudIdAndTimestampResponseList) {
            List<Representation> representations = this.getRepresentationByRevision(this.recordServiceClient, this.representationName, this.revisionName, this.revisionProvider, DateHelper.getUTCDateString(cloudIdAndTimestampResponse.getRevisionTimestamp()), cloudIdAndTimestampResponse.getCloudId());
            for (Representation representation : representations) {
                count += this.addTupleToQueue(this.stormTaskTuple, this.fileServiceClient, representation);
            }
        }
        return count;
    }
}

