/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.utils.TaskTupleUtility;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRecordBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    protected Logger LOGGER = LoggerFactory.getLogger(WriteRecordBolt.class);
    private String ecloudMcsAddress;
    protected RecordServiceClient recordServiceClient;

    public WriteRecordBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
        this.recordServiceClient = new RecordServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(StormTaskTuple t) {
        try {
            this.LOGGER.info("WriteRecordBolt: persisting...");
            URI uri = this.uploadFileInNewRepresentation(t);
            this.LOGGER.info("WriteRecordBolt: file modified, new URI: {}", (Object)uri);
            this.prepareEmittedTuple(t, uri.toString());
            this.outputCollector.emit((List)t.toStormTuple());
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage());
            StringWriter stack = new StringWriter();
            e.printStackTrace(new PrintWriter(stack));
            this.emitErrorNotification(t.getTaskId(), t.getFileUrl(), "Cannot process data because: " + e.getMessage(), stack.toString());
            return;
        }
    }

    protected URI uploadFileInNewRepresentation(StormTaskTuple stormTaskTuple) throws IOException, MCSException, CloudException, DriverException {
        return this.createRepresentationAndUploadFile(stormTaskTuple);
    }

    protected URI createRepresentationAndUploadFile(StormTaskTuple stormTaskTuple) throws IOException, MCSException, CloudException, DriverException {
        int retries = 3;
        while (true) {
            try {
                return this.recordServiceClient.createRepresentation(stormTaskTuple.getParameter("CLOUD_ID"), TaskTupleUtility.getParameterFromTuple(stormTaskTuple, "NEW_REPRESENTATION_NAME"), this.getProviderId(stormTaskTuple), stormTaskTuple.getFileByteDataAsStream(), stormTaskTuple.getParameter("OUTPUT_FILE_NAME"), TaskTupleUtility.getParameterFromTuple(stormTaskTuple, "OUTPUT_MIME_TYPE"), "Authorization", stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while creating representation and uploading file. Retries left {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating representation and uploading file.");
                throw e;
            }
            break;
        }
    }

    private String getProviderId(StormTaskTuple stormTaskTuple) throws MCSException, DriverException {
        Representation rep = this.getRepresentation(stormTaskTuple);
        return rep.getDataProvider();
    }

    private Representation getRepresentation(StormTaskTuple stormTaskTuple) throws MCSException {
        int retries = 3;
        while (true) {
            try {
                return this.recordServiceClient.getRepresentation(stormTaskTuple.getParameter("CLOUD_ID"), stormTaskTuple.getParameter("REPRESENTATION_NAME"), stormTaskTuple.getParameter("REPRESENTATION_VERSION"), "Authorization", stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while getting provider id. Retries left {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while getting provider id. Retries left");
                throw e;
            }
            break;
        }
    }

    private void prepareEmittedTuple(StormTaskTuple stormTaskTuple, String resultedResourceURL) {
        stormTaskTuple.addParameter("OUTPUT_URL", resultedResourceURL);
        stormTaskTuple.setFileData((byte[])null);
        stormTaskTuple.getParameters().remove("CLOUD_ID");
        stormTaskTuple.getParameters().remove("REPRESENTATION_NAME");
        stormTaskTuple.getParameters().remove("REPRESENTATION_VERSION");
    }
}

