/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.WrongContentRangeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFileBolt
extends AbstractDpsBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadFileBolt.class);
    private final String ecloudMcsAddress;
    protected FileServiceClient fileClient;

    public ReadFileBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
        this.fileClient = new FileServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(StormTaskTuple t) {
        String file = t.getParameters().get("CLOUD_LOCAL_IDENTIFIER");
        try (InputStream is = this.getFileStreamByStormTuple(t);){
            t.setFileData(is);
            this.outputCollector.emit((List)t.toStormTuple());
        }
        catch (FileNotExistsException | RepresentationNotExistsException | WrongContentRangeException ex) {
            LOGGER.warn("Can not retrieve file at {}", (Object)file);
            this.emitErrorNotification(t.getTaskId(), file, "Can not retrieve file", "The cause of the error is:" + ex.getCause());
        }
        catch (DriverException | MCSException | IOException ex) {
            LOGGER.error("ReadFileBolt error: {}", (Object)ex.getMessage());
            this.emitErrorNotification(t.getTaskId(), file, ex.getMessage(), "The cause of the error is:" + ex.getCause());
        }
    }

    private InputStream getFile(FileServiceClient fileClient, String file, String authorization) throws MCSException, IOException, DriverException {
        int retries = 3;
        while (true) {
            try {
                return fileClient.getFile(file, "Authorization", authorization);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while getting a file. Retries left:{} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while getting a file.");
                throw e;
            }
            break;
        }
    }

    protected InputStream getFileStreamByStormTuple(StormTaskTuple stormTaskTuple) throws MCSException, IOException, DriverException {
        String file = stormTaskTuple.getParameters().get("CLOUD_LOCAL_IDENTIFIER");
        stormTaskTuple.setFileUrl(file);
        LOGGER.info("HERE THE LINK: {}", (Object)file);
        return this.getFile(this.fileClient, file, stormTaskTuple.getParameter("AUTHORIZATION_HEADER"));
    }
}

