/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class StormTaskTuple
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fileUrl;
    private byte[] fileData;
    private long taskId;
    private String taskName;
    private Map<String, String> parameters;
    private static final int BATCH_MAX_SIZE = 4096;
    private Revision revisionToBeApplied;
    private OAIPMHHarvestingDetails sourceDetails;

    public StormTaskTuple() {
        this.taskName = "";
        this.parameters = new HashMap<String, String>();
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revision) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.fileUrl = fileUrl;
        this.fileData = fileData;
        this.parameters = parameters;
        this.revisionToBeApplied = revision;
    }

    public StormTaskTuple(long taskId, String taskName, String fileUrl, byte[] fileData, Map<String, String> parameters, Revision revision, OAIPMHHarvestingDetails sourceDetails) {
        this(taskId, taskName, fileUrl, fileData, parameters, revision);
        this.sourceDetails = sourceDetails;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public ByteArrayInputStream getFileByteDataAsStream() {
        if (this.fileData != null) {
            return new ByteArrayInputStream(this.fileData);
        }
        return null;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileData(InputStream is) throws IOException {
        try (ByteArrayOutputStream tempByteArrayOutputStream = new ByteArrayOutputStream();){
            if (is != null) {
                byte[] buffer = new byte[4096];
                IOUtils.copyLarge(is, tempByteArrayOutputStream, buffer);
                this.fileData = tempByteArrayOutputStream.toByteArray();
            } else {
                this.fileData = null;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public void addParameter(String parameterKey, String parameterValue) {
        this.parameters.put(parameterKey, parameterValue);
    }

    public OAIPMHHarvestingDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public void setSourceDetails(OAIPMHHarvestingDetails sourceDetails) {
        this.sourceDetails = sourceDetails;
    }

    public String getParameter(String parameterKey) {
        return this.parameters.get(parameterKey);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Revision getRevisionToBeApplied() {
        return this.revisionToBeApplied;
    }

    public void setRevisionToBeApplied(Revision revision) {
        this.revisionToBeApplied = revision;
    }

    public boolean hasRevisionToBeApplied() {
        return this.revisionToBeApplied != null;
    }

    public static StormTaskTuple fromStormTuple(Tuple tuple) {
        return new StormTaskTuple(tuple.getLongByField("TASK_ID"), tuple.getStringByField("TASK_NAME"), tuple.getStringByField("INPUT_FILES"), tuple.getBinaryByField("FILE_CONTENT"), (HashMap)tuple.getValueByField("PARAMETERS"), (Revision)tuple.getValueByField("REVISIONS"), (OAIPMHHarvestingDetails)tuple.getValueByField("SOURCE"));
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.taskName, this.fileUrl, this.fileData, this.parameters, this.revisionToBeApplied, this.sourceDetails});
    }

    public static Fields getFields() {
        return new Fields(new String[]{"TASK_ID", "TASK_NAME", "INPUT_FILES", "FILE_CONTENT", "PARAMETERS", "REVISIONS", "SOURCE"});
    }
}

