/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.service.dps.storm.NotificationBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAINotificationBolt
extends NotificationBolt {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAINotificationBolt.class);

    public OAINotificationBolt(String hosts, int port, String keyspaceName, String userName, String password) {
        super(hosts, port, keyspaceName, userName, password);
    }

    @Override
    protected void insertRecordDetailedInformation(int resourceNum, long taskId, String resource, String state, String infoText, String additionalInfo, String resultResource) {
        int retries = 3;
        while (true) {
            try {
                this.processedRecordsDAO.insert(taskId, resource, resultResource, this.topologyName, state, infoText, additionalInfo);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while inserting detailed record information to cassandra. Retries left: {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while inserting detailed record information to cassandra.");
                throw e;
            }
            break;
        }
    }
}

