/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.common.model.dps.InformationTypes;
import eu.europeana.cloud.common.model.dps.RecordState;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class NotificationTuple {
    public static final String taskIdFieldName = "TASK_ID";
    public static final String informationTypeFieldName = "INFORMATION_TYPE";
    public static final String parametersFieldName = "PARAMETERS";
    private final long taskId;
    private final InformationTypes informationType;
    private final Map<String, Object> parameters;

    protected NotificationTuple(long taskId, InformationTypes informationType, Map<String, Object> parameters) {
        this.taskId = taskId;
        this.informationType = informationType;
        this.parameters = parameters;
    }

    public static NotificationTuple prepareUpdateTask(long taskId, String info, TaskState state, Date startTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("state", state.toString());
        parameters.put("start_time", startTime);
        parameters.put("info", info);
        return new NotificationTuple(taskId, InformationTypes.UPDATE_TASK, parameters);
    }

    public static NotificationTuple prepareEndTask(long taskId, String info, TaskState state, Date finishTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("state", state.toString());
        parameters.put("finish_time", finishTime);
        parameters.put("info", info);
        return new NotificationTuple(taskId, InformationTypes.END_TASK, parameters);
    }

    public static NotificationTuple prepareNotification(long taskId, String resource, RecordState state, String text, String additionalInformations) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        return new NotificationTuple(taskId, InformationTypes.NOTIFICATION, parameters);
    }

    public static NotificationTuple prepareNotification(long taskId, String resource, RecordState state, String text, String additionalInformations, String resultResource) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        parameters.put("resultResource", resultResource);
        return new NotificationTuple(taskId, InformationTypes.NOTIFICATION, parameters);
    }

    public static NotificationTuple prepareIndexingNotification(long taskId, DataSetCleanerParameters dataSetCleanerParameters, String dpsURL, String authenticationHeader, String resource, RecordState state, String text, String additionalInformations, String resultResource) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resource", resource);
        parameters.put("state", state.toString());
        parameters.put("info_text", text);
        parameters.put("additionalInfo", additionalInformations);
        parameters.put("resultResource", resultResource);
        parameters.put("DATA_SET_CLEANING_PARAMETERS", dataSetCleanerParameters);
        parameters.put("DPS_URL", dpsURL);
        parameters.put("AUTHORIZATION_HEADER", authenticationHeader);
        return new NotificationTuple(taskId, InformationTypes.NOTIFICATION, parameters);
    }

    public long getTaskId() {
        return this.taskId;
    }

    public InformationTypes getInformationType() {
        return this.informationType;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public static NotificationTuple fromStormTuple(Tuple tuple) {
        return new NotificationTuple(tuple.getLongByField(taskIdFieldName), (InformationTypes)((Object)tuple.getValueByField(informationTypeFieldName)), (Map)tuple.getValueByField(parametersFieldName));
    }

    public Values toStormTuple() {
        return new Values(new Object[]{this.taskId, this.informationType, this.parameters});
    }

    public static Fields getFields() {
        return new Fields(new String[]{taskIdFieldName, informationTypeFieldName, parametersFieldName});
    }
}

