/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.metis.indexing.DataSetCleanerParameters;
import eu.europeana.cloud.service.dps.storm.NotificationBolt;
import eu.europeana.cloud.service.dps.storm.NotificationTuple;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingNotificationBolt
extends NotificationBolt {
    private static final String AUTHORIZATION = "Authorization";
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingNotificationBolt.class);

    public IndexingNotificationBolt(String hosts, int port, String keyspaceName, String userName, String password) {
        super(hosts, port, keyspaceName, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endTask(NotificationTuple notificationTuple, int errors, int count) {
        long taskId = notificationTuple.getTaskId();
        try (DpsClient dpsClient = null;){
            this.taskStatusUpdater.endTask(taskId, count, errors, TaskState.REMOVING_FROM_SOLR_AND_MONGO.toString(), TaskState.REMOVING_FROM_SOLR_AND_MONGO.toString(), new Date());
            dpsClient = new DpsClient(notificationTuple.getParameter("DPS_URL").toString());
            DataSetCleanerParameters dataSetCleanerParameters = (DataSetCleanerParameters)notificationTuple.getParameter("DATA_SET_CLEANING_PARAMETERS");
            LOGGER.info("DataSet {} will be sent to be cleaned", (Object)dataSetCleanerParameters.getDataSetId());
            dpsClient.cleanMetisIndexingDataset("indexer", taskId, dataSetCleanerParameters, AUTHORIZATION, notificationTuple.getParameter("AUTHORIZATION_HEADER").toString());
            LOGGER.info("DataSet {} is sent to be cleaned and the task is finished successfully from within Storm", (Object)dataSetCleanerParameters.getDataSetId());
        }
    }
}

