/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.permissions;

import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;

public class PermissionsGrantingManager {
    @Autowired
    private MutableAclService mutableAclService;

    public void grantPermissions(String objectType, String objectIdentifier, String userName, List<Permission> listOfPermissions) {
        MutableAcl versionAcl;
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(objectType, (Serializable)((Object)objectIdentifier));
        try {
            versionAcl = (MutableAcl)this.mutableAclService.readAclById(objectIdentity);
        }
        catch (NotFoundException ex) {
            versionAcl = this.mutableAclService.createAcl(objectIdentity);
        }
        for (Permission permission : listOfPermissions) {
            versionAcl.insertAce(versionAcl.getEntries().size(), permission, new PrincipalSid(userName), true);
        }
        this.mutableAclService.updateAcl(versionAcl);
    }

    public void removePermissions(String objectType, String objectIdentifier, String userName, List<Permission> listOfPermissions) {
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(objectType, (Serializable)((Object)objectIdentifier));
        this.removePermissions(objectIdentity, userName, listOfPermissions);
    }

    public void removePermissions(ObjectIdentity objectIdentity, String userName, List<Permission> listOfPermissions) {
        MutableAcl objectAcl = (MutableAcl)this.mutableAclService.readAclById(objectIdentity);
        for (int i = objectAcl.getEntries().size() - 1; i >= 0; --i) {
            PrincipalSid s;
            AccessControlEntry currentEntry = objectAcl.getEntries().get(i);
            if (!(currentEntry.getSid() instanceof PrincipalSid) || !userName.equals((s = (PrincipalSid)currentEntry.getSid()).getPrincipal()) || !this.isPermissionOnTheList(currentEntry.getPermission(), listOfPermissions)) continue;
            objectAcl.deleteAce(i);
        }
        this.mutableAclService.updateAcl(objectAcl);
    }

    private boolean isPermissionOnTheList(Permission permission, List<Permission> listOfPermissions) {
        for (Permission permissionFromList : listOfPermissions) {
            if (!permissionFromList.equals(permission)) continue;
            return true;
        }
        return false;
    }
}

