/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.BSONObject;

public final class IterHelper<K, V> {
    public void loopMap(Object x, MapIterCallback<K, V> callback) {
        if (x == null) {
            return;
        }
        if (x instanceof Collection) {
            throw new IllegalArgumentException("call loop instead");
        }
        if (x instanceof HashMap) {
            if (((HashMap)x).isEmpty()) {
                return;
            }
            HashMap hm = (HashMap)x;
            for (Map.Entry e : hm.entrySet()) {
                callback.eval((String)e.getKey(), e.getValue());
            }
            return;
        }
        if (x instanceof Map) {
            Map m = (Map)x;
            for (Map.Entry entry : m.entrySet()) {
                callback.eval((String)entry.getKey(), entry.getValue());
            }
            return;
        }
        if (x instanceof BSONObject) {
            BSONObject m = (BSONObject)x;
            for (String k : m.keySet()) {
                callback.eval(k, m.get(k));
            }
        }
    }

    public void loopOrSingle(Object x, IterCallback<V> callback) {
        if (x == null) {
            return;
        }
        if (x instanceof Collection) {
            Collection l = (Collection)x;
            for (Object o : l) {
                callback.eval(o);
            }
            return;
        }
        if (x.getClass().isArray()) {
            for (Object o : (Object[])x) {
                callback.eval(o);
            }
            return;
        }
        callback.eval(x);
    }

    public static abstract class IterCallback<V> {
        public abstract void eval(V var1);
    }

    public static abstract class MapIterCallback<K, V> {
        public abstract void eval(K var1, V var2);
    }
}

