/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.mapping.MappedField;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.validation.OperationValidator;
import dev.morphia.query.validation.ValidationFailure;
import dev.morphia.utils.ReflectionUtils;
import java.lang.reflect.Array;
import java.util.List;

public final class ModOperationValidator
extends OperationValidator {
    private static final ModOperationValidator INSTANCE = new ModOperationValidator();

    private ModOperationValidator() {
    }

    public static ModOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.MOD;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value == null) {
            validationFailures.add(new ValidationFailure("For a $mod operation, value cannot be null."));
        } else if (value.getClass().isArray()) {
            if (Array.getLength(value) != 2) {
                validationFailures.add(new ValidationFailure(String.format("For a $mod operation, value '%s' should be an array with two integer elements.  Instead it had %s", value, Array.getLength(value))));
            }
            if (!ReflectionUtils.isIntegerType(value.getClass().getComponentType())) {
                validationFailures.add(new ValidationFailure(String.format("Array value needs to contain integers for $mod, but contained: %s", value.getClass().getComponentType())));
            }
        } else {
            validationFailures.add(new ValidationFailure(String.format("For a $mod operation, value '%s' should be an integer array.  Instead it was a: %s", value, value.getClass())));
        }
    }
}

