/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.Key;
import dev.morphia.query.validation.ValidationFailure;
import dev.morphia.query.validation.ValueValidator;
import java.util.List;

public final class KeyValueTypeValidator
extends ValueValidator {
    private static final KeyValueTypeValidator INSTANCE = new KeyValueTypeValidator();

    private KeyValueTypeValidator() {
    }

    public static KeyValueTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<?> getRequiredValueType() {
        return Key.class;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (!type.equals(((Key)value).getType()) && !type.equals(Key.class)) {
            validationFailures.add(new ValidationFailure(String.format("When value is a Key, the type needs to be the right kind of class. Type was %s and value was '%s'", type, value)));
        }
    }
}

