/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.validation;

import dev.morphia.mapping.MappedField;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.validation.CollectionTypeValidator;
import dev.morphia.query.validation.OperationValidator;
import dev.morphia.query.validation.ValidationFailure;
import java.util.List;

public final class InOperationValidator
extends OperationValidator {
    private static final InOperationValidator INSTANCE = new InOperationValidator();

    private InOperationValidator() {
    }

    public static InOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.IN;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value == null) {
            validationFailures.add(new ValidationFailure(String.format("For an $in operation, value cannot be null.", new Object[0])));
        } else if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(value.getClass())) {
            validationFailures.add(new ValidationFailure(String.format("For a $in operation, value '%s' should be a List or array or Map. Instead it was a: %s", value, value.getClass())));
        }
    }
}

