/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.internal;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.MongoCursor;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.mapping.Mapper;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class MorphiaKeyCursor<T>
implements MongoCursor<Key<T>> {
    private final Cursor wrapped;
    private final Mapper mapper;
    private final Class<T> clazz;
    private final String collection;
    private final Datastore datastore;

    public MorphiaKeyCursor(Datastore datastore, Cursor cursor, Mapper mapper, Class<T> clazz, String collection) {
        this.datastore = datastore;
        this.wrapped = cursor;
        if (this.wrapped == null) {
            throw new IllegalArgumentException("The wrapped cursor can not be null");
        }
        this.mapper = mapper;
        this.clazz = clazz;
        this.collection = collection;
    }

    @Override
    public void close() {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        return this.wrapped.hasNext();
    }

    @Override
    public Key<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.convertItem((DBObject)this.wrapped.next());
    }

    @Override
    public Key<T> tryNext() {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    public List<Key<T>> toList() {
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        try {
            while (this.wrapped.hasNext()) {
                results.add((Key<T>)this.next());
            }
        }
        finally {
            this.wrapped.close();
        }
        return results;
    }

    @Override
    public ServerCursor getServerCursor() {
        return new ServerCursor(this.wrapped.getCursorId(), this.wrapped.getServerAddress());
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }

    private Key<T> convertItem(DBObject dbObj) {
        Object id = dbObj.get("_id");
        if (id instanceof DBObject) {
            Class type = this.mapper.getMappedClass(this.clazz).getMappedIdField().getType();
            id = this.mapper.fromDBObject(this.datastore, type, (DBObject)id, this.mapper.createEntityCache());
        }
        return new Key<T>(this.clazz, this.collection, id);
    }
}

