/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.Block;
import com.mongodb.CursorType;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.DBCollectionFindOptions;
import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.Key;
import dev.morphia.annotations.Entity;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.cache.EntityCache;
import dev.morphia.query.ArraySlice;
import dev.morphia.query.CountOptions;
import dev.morphia.query.Criteria;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.CriteriaContainerImpl;
import dev.morphia.query.CriteriaJoin;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Meta;
import dev.morphia.query.MorphiaIterator;
import dev.morphia.query.MorphiaKeyIterator;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.ValidationException;
import dev.morphia.query.WhereCriteria;
import dev.morphia.query.internal.MappingIterable;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.internal.MorphiaKeyCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.types.CodeWScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl<T>
implements CriteriaContainer,
Query<T> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpl.class);
    private final DatastoreImpl ds;
    private final DBCollection dbColl;
    private final Class<T> clazz;
    private EntityCache cache;
    private boolean validateName = true;
    private boolean validateType = true;
    private Boolean includeFields;
    private DBObject baseQuery;
    private FindOptions options;
    private CriteriaContainer compoundContainer = new CriteriaContainerImpl(this, CriteriaJoin.AND);

    FindOptions getOptions() {
        if (this.options == null) {
            this.options = new FindOptions();
        }
        return this.options;
    }

    public QueryImpl(Class<T> clazz, DBCollection coll, Datastore ds) {
        Entity entAn;
        this.clazz = clazz;
        this.ds = (DatastoreImpl)ds;
        this.dbColl = coll;
        this.cache = this.ds.getMapper().createEntityCache();
        MappedClass mc = this.ds.getMapper().getMappedClass(clazz);
        Entity entity = entAn = mc == null ? null : mc.getEntityAnnotation();
        if (entAn != null) {
            this.getOptions().readPreference(this.ds.getMapper().getMappedClass(clazz).getEntityAnnotation().queryNonPrimary() ? ReadPreference.secondaryPreferred() : null);
        }
    }

    @Deprecated
    public static BasicDBObject parseFieldsString(String str, Class clazz, Mapper mapper, boolean validate) {
        String[] parts;
        BasicDBObject ret = new BasicDBObject();
        for (String s : parts = str.split(",")) {
            s = s.trim();
            int dir = 1;
            if (s.startsWith("-")) {
                dir = -1;
                s = s.substring(1).trim();
            }
            if (validate) {
                s = new PathTarget(mapper, clazz, s).translatedPath();
            }
            ret.put(s, dir);
        }
        return ret;
    }

    @Override
    public MorphiaKeyCursor<T> keys() {
        return this.keys(new FindOptions());
    }

    @Override
    public MorphiaKeyCursor<T> keys(FindOptions options) {
        Query cloned = this.cloneQuery();
        ((QueryImpl)cloned).getOptions().projection(new BasicDBObject("_id", (Object)1));
        ((QueryImpl)cloned).includeFields = true;
        return new MorphiaKeyCursor<T>(this.ds, super.prepareCursor(options), this.ds.getMapper(), this.clazz, this.dbColl.getName());
    }

    @Override
    public List<Key<T>> asKeyList() {
        return this.asKeyList(this.getOptions());
    }

    @Override
    public List<Key<T>> asKeyList(FindOptions options) {
        return this.keys(options).toList();
    }

    @Override
    public List<T> asList() {
        return this.find(this.getOptions()).toList();
    }

    @Override
    public List<T> asList(FindOptions options) {
        return this.find(options).toList();
    }

    @Override
    @Deprecated
    public long countAll() {
        DBObject query = this.getQueryObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing count(" + this.dbColl.getName() + ") for query: " + query);
        }
        return this.dbColl.getCount(query);
    }

    @Override
    public long count() {
        return this.dbColl.getCount(this.getQueryObject());
    }

    @Override
    public long count(CountOptions options) {
        return this.dbColl.getCount(this.getQueryObject(), options.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetch() {
        return this.fetch(this.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetch(FindOptions options) {
        DBCursor cursor = this.prepareCursor(options);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting cursor(" + this.dbColl.getName() + ")  for query:" + cursor.getQuery());
        }
        return new MorphiaIterator(this.ds, this.prepareCursor(options), this.ds.getMapper(), this.clazz, this.dbColl.getName(), this.cache);
    }

    @Override
    public MorphiaCursor<T> find() {
        return this.find(this.getOptions());
    }

    @Override
    public MorphiaCursor<T> find(FindOptions options) {
        return new MorphiaCursor<T>(this.ds, this.prepareCursor(options), this.ds.getMapper(), this.clazz, this.cache);
    }

    @Override
    public MorphiaIterator<T, T> fetchEmptyEntities() {
        return this.fetchEmptyEntities(this.getOptions());
    }

    @Override
    public MorphiaIterator<T, T> fetchEmptyEntities(FindOptions options) {
        Query cloned = this.cloneQuery();
        ((QueryImpl)cloned).getOptions().projection(new BasicDBObject("_id", (Object)1));
        ((QueryImpl)cloned).includeFields = true;
        return ((QueryImpl)cloned).fetch(options);
    }

    @Override
    public MorphiaKeyIterator<T> fetchKeys() {
        return this.fetchKeys(this.getOptions());
    }

    @Override
    public MorphiaKeyIterator<T> fetchKeys(FindOptions options) {
        Query cloned = this.cloneQuery();
        FindOptions opts = ((QueryImpl)cloned).getOptions();
        opts.projection(new BasicDBObject("_id", (Object)1));
        ((QueryImpl)cloned).includeFields = true;
        return new MorphiaKeyIterator<T>(this.ds, super.prepareCursor(options), this.ds.getMapper(), this.clazz, this.dbColl.getName());
    }

    @Override
    public T first() {
        try (Iterator iterator = this.iterator();){
            Object TResult = iterator.tryNext();
            return (T)TResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T first(FindOptions options) {
        try (MorphiaCursor<T> it = this.find(options.copy().limit(1));){
            Object TResult = it.tryNext();
            return (T)TResult;
        }
    }

    @Override
    public T get() {
        return this.first(this.getOptions());
    }

    @Override
    public T get(FindOptions options) {
        return this.first(options);
    }

    @Override
    public Key<T> getKey() {
        return this.getKey(this.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key<T> getKey(FindOptions options) {
        try (MorphiaKeyCursor<T> it = this.keys(options.copy().limit(1));){
            Key key = (Key)it.tryNext();
            return key;
        }
    }

    @Override
    @Deprecated
    public MorphiaIterator<T, T> tail() {
        return this.tail(true);
    }

    @Override
    @Deprecated
    public MorphiaIterator<T, T> tail(boolean awaitData) {
        return this.fetch(this.getOptions().copy().cursorType(awaitData ? CursorType.TailableAwait : CursorType.Tailable));
    }

    @Override
    @Deprecated
    public Query<T> batchSize(int value) {
        this.getOptions().batchSize(value);
        return this;
    }

    @Override
    public QueryImpl<T> cloneQuery() {
        QueryImpl<T> n = new QueryImpl<T>(this.clazz, this.dbColl, this.ds);
        n.cache = this.ds.getMapper().createEntityCache();
        n.includeFields = this.includeFields;
        n.validateName = this.validateName;
        n.validateType = this.validateType;
        n.baseQuery = this.copy(this.baseQuery);
        n.options = this.options != null ? this.options.copy() : null;
        n.compoundContainer = this.compoundContainer;
        return n;
    }

    private BasicDBObject copy(DBObject dbObject) {
        return dbObject == null ? null : new BasicDBObject(dbObject.toMap());
    }

    @Override
    @Deprecated
    public Query<T> comment(String comment) {
        this.getOptions().modifier("$comment", comment);
        return this;
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String field) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this, field, container);
    }

    @Override
    @Deprecated
    public Query<T> disableCursorTimeout() {
        this.getOptions().noCursorTimeout(true);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> disableSnapshotMode() {
        this.getOptions().getModifiers().removeField("$snapshot");
        return this;
    }

    @Override
    public Query<T> disableValidation() {
        this.validateName = false;
        this.validateType = false;
        return this;
    }

    @Override
    @Deprecated
    public Query<T> enableCursorTimeout() {
        this.getOptions().noCursorTimeout(false);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> enableSnapshotMode() {
        this.getOptions().modifier("$snapshot", true);
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateName = true;
        this.validateType = true;
        return this;
    }

    @Override
    public Map<String, Object> explain() {
        return this.explain(this.getOptions());
    }

    @Override
    public Map<String, Object> explain(FindOptions options) {
        return this.prepareCursor(options).explain().toMap();
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return new FieldEndImpl<QueryImpl>(this, name, this);
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this, prop, op, value));
        return this;
    }

    @Override
    @Deprecated
    public int getBatchSize() {
        return this.getOptions().getBatchSize();
    }

    @Override
    @Deprecated
    public DBCollection getCollection() {
        return this.dbColl;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    @Deprecated
    public DBObject getFieldsObject() {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null || projection.keySet().isEmpty()) {
            return null;
        }
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        Entity entityAnnotation = mc.getEntityAnnotation();
        BasicDBObject fieldsFilter = this.copy(projection);
        if (this.includeFields.booleanValue() && entityAnnotation != null && !entityAnnotation.noClassnameStored()) {
            fieldsFilter.put(this.ds.getMapper().getOptions().getDiscriminatorField(), 1);
        }
        return fieldsFilter;
    }

    @Override
    @Deprecated
    public int getLimit() {
        return this.getOptions().getLimit();
    }

    @Override
    @Deprecated
    public int getOffset() {
        return this.getOptions().getSkip();
    }

    @Override
    @Deprecated
    public DBObject getQueryObject() {
        BasicDBObject obj = new BasicDBObject();
        if (this.baseQuery != null) {
            obj.putAll(this.baseQuery.toMap());
        }
        obj.putAll(this.toDBObject());
        return obj;
    }

    public void setQueryObject(DBObject query) {
        this.baseQuery = new BasicDBObject(query.toMap());
    }

    @Override
    @Deprecated
    public DBObject getSortObject() {
        DBObject sort = this.getOptions().getSortDBObject();
        return sort == null ? null : new BasicDBObject(sort.toMap());
    }

    @Override
    @Deprecated
    public Query<T> hintIndex(String idxName) {
        this.getOptions().modifier("$hint", idxName);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> limit(int value) {
        this.getOptions().limit(value);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> lowerIndexBound(DBObject lowerBound) {
        if (lowerBound != null) {
            this.getOptions().modifier("$min", new Document(lowerBound.toMap()));
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> maxScan(int value) {
        if (value > 0) {
            this.getOptions().modifier("$maxScan", value);
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> maxTime(long value, TimeUnit unit) {
        this.getOptions().maxTime(value, unit);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> offset(int value) {
        this.getOptions().skip(value);
        return this;
    }

    @Override
    public Query<T> order(String sort) {
        this.getOptions().sort(QueryImpl.parseFieldsString(sort, this.clazz, this.ds.getMapper(), this.validateName));
        return this;
    }

    @Override
    public Query<T> order(Meta sort) {
        this.getOptions().sort(sort.toDatabase());
        return this;
    }

    @Override
    public Query<T> order(Sort ... sorts) {
        BasicDBObject sortList = new BasicDBObject();
        for (Sort sort : sorts) {
            String s = sort.getField();
            if (this.validateName) {
                s = new PathTarget(this.ds.getMapper(), this.clazz, s).translatedPath();
            }
            sortList.put(s, sort.getOrder());
        }
        this.getOptions().sort(sortList);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> queryNonPrimary() {
        this.getOptions().readPreference(ReadPreference.secondaryPreferred());
        return this;
    }

    @Override
    @Deprecated
    public Query<T> queryPrimaryOnly() {
        this.getOptions().readPreference(ReadPreference.primary());
        return this;
    }

    @Override
    public Query<T> retrieveKnownFields() {
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        ArrayList<String> fields = new ArrayList<String>(mc.getPersistenceFields().size() + 1);
        for (MappedField mf : mc.getPersistenceFields()) {
            fields.add(mf.getNameToStore());
        }
        this.retrievedFields(true, fields.toArray(new String[0]));
        return this;
    }

    @Override
    public Query<T> project(String field, boolean include) {
        Mapper mapper = this.ds.getMapper();
        String fieldName = new PathTarget(mapper, mapper.getMappedClass(this.clazz), field, this.validateName).translatedPath();
        this.validateProjections(fieldName, include);
        this.project(fieldName, include ? 1 : 0);
        return this;
    }

    private void project(String fieldName, Object value) {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null) {
            projection = new BasicDBObject();
            this.getOptions().projection(projection);
        }
        projection.put(fieldName, value);
    }

    private void project(DBObject value) {
        DBObject projection = this.getOptions().getProjection();
        if (projection == null) {
            projection = new BasicDBObject();
            this.getOptions().projection(projection);
        }
        projection.putAll(value);
    }

    @Override
    public Query<T> project(String field, ArraySlice slice) {
        Mapper mapper = this.ds.getMapper();
        String fieldName = new PathTarget(mapper, mapper.getMappedClass(this.clazz), field, this.validateName).translatedPath();
        this.validateProjections(fieldName, true);
        this.project(fieldName, slice.toDatabase());
        return this;
    }

    @Override
    public Query<T> project(Meta meta) {
        Mapper mapper = this.ds.getMapper();
        String fieldName = new PathTarget(mapper, this.clazz, meta.getField(), false).translatedPath();
        this.validateProjections(fieldName, true);
        this.project(meta.toDatabase());
        return this;
    }

    private void validateProjections(String field, boolean include) {
        if (!(this.includeFields == null || include == this.includeFields || this.includeFields.booleanValue() && "_id".equals(field))) {
            throw new ValidationException("You cannot mix included and excluded fields together");
        }
        if (this.includeFields == null) {
            this.includeFields = include;
        }
    }

    @Override
    @Deprecated
    public Query<T> retrievedFields(boolean include, String ... list) {
        if (this.includeFields != null && include != this.includeFields) {
            throw new IllegalStateException("You cannot mix included and excluded fields together");
        }
        for (String field : list) {
            this.project(field, include);
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> returnKey() {
        this.getOptions().getModifiers().put("$returnKey", true);
        return this;
    }

    @Override
    public Query<T> search(String search) {
        BasicDBObject op = new BasicDBObject("$search", search);
        this.criteria("$text").equal(op);
        return this;
    }

    @Override
    public Query<T> search(String search, String language) {
        BasicDBObject op = new BasicDBObject("$search", search).append("$language", language);
        this.criteria("$text").equal(op);
        return this;
    }

    @Override
    @Deprecated
    public Query<T> upperIndexBound(DBObject upperBound) {
        if (upperBound != null) {
            this.getOptions().getModifiers().put("$max", new BasicDBObject(upperBound.toMap()));
        }
        return this;
    }

    @Override
    @Deprecated
    public Query<T> useReadPreference(ReadPreference readPref) {
        this.getOptions().readPreference(readPref);
        return this;
    }

    @Override
    public Query<T> where(String js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public Query<T> where(CodeWScope js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public String getFieldName() {
        throw new UnsupportedOperationException("this method is unused on a Query");
    }

    @Deprecated
    public DatastoreImpl getDatastore() {
        return this.ds;
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public boolean isValidatingTypes() {
        return this.validateType;
    }

    @Override
    public MongoCursor<T> iterator() {
        return this.find();
    }

    @Deprecated
    public DBCursor prepareCursor() {
        return this.prepareCursor(this.getOptions());
    }

    private DBCursor prepareCursor(FindOptions findOptions) {
        DBObject query = this.getQueryObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.dbColl.getName(), query, findOptions));
        }
        if (findOptions.isSnapshot() && (findOptions.getSortDBObject() != null || findOptions.hasHint())) {
            LOG.warn("Snapshotted query should not have hint/sort.");
        }
        if (findOptions.getCursorType() != CursorType.NonTailable && findOptions.getSortDBObject() != null) {
            LOG.warn("Sorting on tail is not allowed.");
        }
        return this.dbColl.find(query, findOptions.getOptions().copy().sort(this.getSortObject()).projection(this.getFieldsObject())).setDecoderFactory(this.ds.getDecoderFact());
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        try (Iterator cursor = this.iterator();){
            while (cursor.hasNext()) {
                block.apply(cursor.next());
            }
        }
    }

    @Override
    public <A extends Collection<? super T>> A into(final A target) {
        this.forEach(new Block<T>(){

            @Override
            public void apply(T t) {
                target.add(t);
            }
        });
        return target;
    }

    public String toString() {
        return String.format("{ %s %s }", this.getQueryObject(), this.getOptions().getProjection() == null ? "" : ", projection: " + this.getFieldsObject());
    }

    private FilterOperator translate(String operator) {
        return FilterOperator.fromString(operator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryImpl)) {
            return false;
        }
        QueryImpl query = (QueryImpl)o;
        if (this.validateName != query.validateName) {
            return false;
        }
        if (this.validateType != query.validateType) {
            return false;
        }
        if (!this.dbColl.equals(query.dbColl)) {
            return false;
        }
        if (!this.clazz.equals(query.clazz)) {
            return false;
        }
        if (this.includeFields != null ? !this.includeFields.equals(query.includeFields) : query.includeFields != null) {
            return false;
        }
        if (this.baseQuery != null ? !this.baseQuery.equals(query.baseQuery) : query.baseQuery != null) {
            return false;
        }
        return this.compare(this.options, query.options);
    }

    private boolean compare(FindOptions these, FindOptions those) {
        if (these == null && those != null || these != null && those == null) {
            return false;
        }
        if (these == null) {
            return true;
        }
        DBCollectionFindOptions dbOptions = these.getOptions();
        DBCollectionFindOptions that = those.getOptions();
        if (dbOptions.getBatchSize() != that.getBatchSize()) {
            return false;
        }
        if (dbOptions.getLimit() != that.getLimit()) {
            return false;
        }
        if (dbOptions.getMaxTime(TimeUnit.MILLISECONDS) != that.getMaxTime(TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (dbOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS) != that.getMaxAwaitTime(TimeUnit.MILLISECONDS)) {
            return false;
        }
        if (dbOptions.getSkip() != that.getSkip()) {
            return false;
        }
        if (dbOptions.isNoCursorTimeout() != that.isNoCursorTimeout()) {
            return false;
        }
        if (dbOptions.isOplogReplay() != that.isOplogReplay()) {
            return false;
        }
        if (dbOptions.isPartial() != that.isPartial()) {
            return false;
        }
        if (!dbOptions.getModifiers().equals(that.getModifiers())) {
            return false;
        }
        if (dbOptions.getProjection() != null ? !dbOptions.getProjection().equals(that.getProjection()) : that.getProjection() != null) {
            return false;
        }
        if (dbOptions.getSort() != null ? !dbOptions.getSort().equals(that.getSort()) : that.getSort() != null) {
            return false;
        }
        if (dbOptions.getCursorType() != that.getCursorType()) {
            return false;
        }
        if (dbOptions.getReadPreference() != null ? !dbOptions.getReadPreference().equals(that.getReadPreference()) : that.getReadPreference() != null) {
            return false;
        }
        if (dbOptions.getReadConcern() != null ? !dbOptions.getReadConcern().equals(that.getReadConcern()) : that.getReadConcern() != null) {
            return false;
        }
        return dbOptions.getCollation() != null ? dbOptions.getCollation().equals(that.getCollation()) : that.getCollation() == null;
    }

    private int hash(FindOptions options) {
        if (options == null) {
            return 0;
        }
        int result = options.getBatchSize();
        result = 31 * result + this.getLimit();
        result = 31 * result + options.getModifiers().hashCode();
        result = 31 * result + (options.getProjection() != null ? options.getProjection().hashCode() : 0);
        result = 31 * result + (int)(options.getMaxTime(TimeUnit.MILLISECONDS) ^ options.getMaxTime(TimeUnit.MILLISECONDS) >>> 32);
        result = 31 * result + (int)(options.getMaxAwaitTime(TimeUnit.MILLISECONDS) ^ options.getMaxAwaitTime(TimeUnit.MILLISECONDS) >>> 32);
        result = 31 * result + options.getSkip();
        result = 31 * result + (options.getSortDBObject() != null ? options.getSortDBObject().hashCode() : 0);
        result = 31 * result + options.getCursorType().hashCode();
        result = 31 * result + (options.isNoCursorTimeout() ? 1 : 0);
        result = 31 * result + (options.isOplogReplay() ? 1 : 0);
        result = 31 * result + (options.isPartial() ? 1 : 0);
        result = 31 * result + (options.getReadPreference() != null ? options.getReadPreference().hashCode() : 0);
        result = 31 * result + (options.getReadConcern() != null ? options.getReadConcern().hashCode() : 0);
        result = 31 * result + (options.getCollation() != null ? options.getCollation().hashCode() : 0);
        return result;
    }

    public int hashCode() {
        int result = this.dbColl.hashCode();
        result = 31 * result + this.clazz.hashCode();
        result = 31 * result + (this.validateName ? 1 : 0);
        result = 31 * result + (this.validateType ? 1 : 0);
        result = 31 * result + (this.includeFields != null ? this.includeFields.hashCode() : 0);
        result = 31 * result + (this.baseQuery != null ? this.baseQuery.hashCode() : 0);
        result = 31 * result + this.hash(this.options);
        return result;
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.compoundContainer.add(c);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.compoundContainer.and(criteria);
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.compoundContainer.or(criteria);
    }

    @Override
    public DBObject toDBObject() {
        return this.compoundContainer.toDBObject();
    }

    @Override
    public void remove(Criteria criteria) {
        this.compoundContainer.remove(criteria);
    }

    @Override
    public void attach(CriteriaContainer container) {
        this.compoundContainer.attach(container);
    }
}

