/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.geo.CoordinateReferenceSystem;
import dev.morphia.geo.Geometry;
import dev.morphia.geo.GeometryQueryConverter;
import dev.morphia.geo.NamedCoordinateReferenceSystemConverter;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.QueryImpl;
import org.bson.Document;

final class Geo2dSphereCriteria
extends FieldCriteria {
    private Document options;
    private final Geometry geometry;
    private CoordinateReferenceSystem crs;

    private Geo2dSphereCriteria(QueryImpl<?> query, String field, FilterOperator operator, Geometry geometry) {
        super(query, field, operator, geometry);
        this.geometry = geometry;
    }

    static Geo2dSphereCriteria geo(QueryImpl<?> query, String field, FilterOperator operator, Geometry value) {
        return new Geo2dSphereCriteria(query, field, operator, value);
    }

    Geo2dSphereCriteria maxDistance(Double maxDistance) {
        return this.manageOption("$maxDistance", maxDistance);
    }

    Geo2dSphereCriteria minDistance(Double minDistance) {
        return this.manageOption("$minDistance", minDistance);
    }

    private Geo2dSphereCriteria manageOption(String key, Object value) {
        if (this.options == null) {
            this.options = new Document();
        }
        if (value == null) {
            this.options.remove(key);
        } else {
            this.options.put(key, value);
        }
        return this;
    }

    Geo2dSphereCriteria addCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObject query;
        FilterOperator operator = this.getOperator();
        GeometryQueryConverter geometryQueryConverter = new GeometryQueryConverter(this.getQuery().getDatastore().getMapper());
        DBObject geometryAsDBObject = (DBObject)geometryQueryConverter.encode(this.geometry, null);
        switch (operator) {
            case NEAR: 
            case NEAR_SPHERE: {
                if (this.options != null) {
                    geometryAsDBObject.putAll(this.options);
                }
                query = new BasicDBObject(FilterOperator.NEAR.val(), geometryAsDBObject);
                break;
            }
            case GEO_WITHIN: 
            case INTERSECTS: {
                query = new BasicDBObject(operator.val(), geometryAsDBObject);
                if (this.crs == null) break;
                ((DBObject)geometryAsDBObject.get("$geometry")).put("crs", new NamedCoordinateReferenceSystemConverter().encode(this.crs));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operator %s not supported for geo-query", operator.val()));
            }
        }
        return new BasicDBObject(this.getField(), query);
    }
}

