/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.QueryImpl;
import java.util.Map;

class Geo2dCriteria
extends FieldCriteria {
    private final Map<String, Object> opts;

    Geo2dCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value, Map<String, Object> opts) {
        super(query, field, op, value);
        this.opts = opts;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObjectBuilder query;
        BasicDBObject obj = new BasicDBObject();
        switch (this.getOperator()) {
            case NEAR: {
                query = BasicDBObjectBuilder.start(FilterOperator.NEAR.val(), this.getValue());
                break;
            }
            case NEAR_SPHERE: {
                query = BasicDBObjectBuilder.start(FilterOperator.NEAR_SPHERE.val(), this.getValue());
                break;
            }
            case WITHIN_BOX: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            case WITHIN_CIRCLE: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            case WITHIN_CIRCLE_SPHERE: {
                query = BasicDBObjectBuilder.start().push(FilterOperator.GEO_WITHIN.val()).add(this.getOperator().val(), this.getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.getOperator()) + " not supported for geo-query");
            }
        }
        if (this.opts != null) {
            for (Map.Entry<String, Object> e : this.opts.entrySet()) {
                query.append(e.getKey(), e.getValue());
            }
        }
        obj.put(this.getField(), query.get());
        return obj;
    }
}

