/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.AbstractCriteria;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.QueryImpl;
import dev.morphia.utils.ReflectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FieldCriteria
extends AbstractCriteria {
    private static final Logger LOG = LoggerFactory.getLogger(FieldCriteria.class);
    private final String field;
    private final FilterOperator operator;
    private final Object value;
    private final boolean not;
    private final QueryImpl<?> query;

    FieldCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value) {
        this(query, field, op, value, false);
    }

    FieldCriteria(QueryImpl<?> query, String fieldName, FilterOperator op, Object value, boolean not) {
        Class<?> type;
        this.query = query;
        Mapper mapper = query.getDatastore().getMapper();
        PathTarget pathTarget = new PathTarget(mapper, mapper.getMappedClass(query.getEntityClass()), fieldName, query.isValidatingNames());
        MappedField mf = pathTarget.getTarget();
        MappedClass mc = null;
        try {
            if (value != null && !ReflectionUtils.isPropertyType(value.getClass()) && !ReflectionUtils.implementsInterface(value.getClass(), Iterable.class)) {
                mc = mf != null && !mf.isTypeMongoCompatible() ? mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass()) : mapper.getMappedClass(value);
            }
        }
        catch (Exception e) {
            LOG.debug("Error during mapping of filter criteria: ", e);
        }
        List<Object> mappedValue = mapper.toMongoObject(mf, mc, value);
        Class<?> clazz = type = mappedValue == null ? null : mappedValue.getClass();
        if (!(type == null || op != FilterOperator.IN && op != FilterOperator.NOT_IN || type.isArray() || Iterable.class.isAssignableFrom(type))) {
            mappedValue = Collections.singletonList(mappedValue);
        }
        if (value != null && type == null && (op == FilterOperator.IN || op == FilterOperator.NOT_IN) && Iterable.class.isAssignableFrom(value.getClass())) {
            mappedValue = Collections.emptyList();
        }
        this.field = pathTarget.translatedPath();
        this.operator = op;
        this.value = mappedValue;
        this.not = not;
    }

    protected QueryImpl<?> getQuery() {
        return this.query;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObject obj = new BasicDBObject();
        if (FilterOperator.EQUAL.equals((Object)this.operator)) {
            if (this.not) {
                obj.put(this.field, new BasicDBObject("$not", this.value));
            } else {
                obj.put(this.field, this.value);
            }
        } else {
            HashMap<String, Object> inner;
            Object object = obj.get(this.field);
            if (!(object instanceof Map)) {
                inner = new HashMap<String, Object>();
                obj.put(this.field, inner);
            } else {
                inner = (HashMap<String, Object>)object;
            }
            if (this.not) {
                inner.put("$not", new BasicDBObject(this.operator.val(), this.value));
            } else {
                inner.put(this.operator.val(), this.value);
            }
        }
        return obj;
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    public String getField() {
        return this.field;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNot() {
        return this.not;
    }

    public String toString() {
        return this.field + " " + this.operator.val() + " " + this.value;
    }
}

