/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.DBCollectionCountOptions;
import java.util.concurrent.TimeUnit;

public class CountOptions {
    private DBCollectionCountOptions options = new DBCollectionCountOptions();

    public CountOptions collation(Collation collation) {
        this.options.collation(collation);
        return this;
    }

    public Collation getCollation() {
        return this.options.getCollation();
    }

    public String getHint() {
        return this.options.getHintString();
    }

    public int getLimit() {
        return this.options.getLimit();
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return this.options.getMaxTime(timeUnit);
    }

    public ReadConcern getReadConcern() {
        return this.options.getReadConcern();
    }

    public ReadPreference getReadPreference() {
        return this.options.getReadPreference();
    }

    public int getSkip() {
        return this.options.getSkip();
    }

    public CountOptions hint(String hint) {
        this.options.hintString(hint);
        return this;
    }

    public CountOptions limit(int limit) {
        this.options.limit(limit);
        return this;
    }

    public CountOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.options.maxTime(maxTime, timeUnit);
        return this;
    }

    public CountOptions readConcern(ReadConcern readConcern) {
        this.options.readConcern(readConcern);
        return this;
    }

    public CountOptions readPreference(ReadPreference readPreference) {
        this.options.readPreference(readPreference);
        return this;
    }

    public CountOptions skip(int skip) {
        this.options.skip(skip);
        return this;
    }

    DBCollectionCountOptions getOptions() {
        return this.options;
    }
}

