/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.aggregation.Accumulator;
import java.util.HashMap;
import java.util.Map;

public class BucketOptions {
    private Object defaultField;
    private Map<String, Accumulator> accumulators = new HashMap<String, Accumulator>();

    public DBObject toDBObject() {
        BasicDBObject dbObject = new BasicDBObject();
        if (this.defaultField != null) {
            dbObject.put("default", this.defaultField);
        }
        BasicDBObject output = new BasicDBObject();
        for (Map.Entry<String, Accumulator> entry : this.accumulators.entrySet()) {
            output.put(entry.getKey(), entry.getValue().toDBObject());
        }
        if (!this.accumulators.isEmpty()) {
            dbObject.put("output", output);
        }
        return dbObject;
    }

    public BucketOptions defaultField(Object defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public OutputOperation output(String fieldName) {
        return new OutputOperation(fieldName);
    }

    public Object getDefaultField() {
        return this.defaultField;
    }

    public Map<String, Accumulator> getAccumulators() {
        return this.accumulators;
    }

    public class OutputOperation {
        private String fieldName;

        public OutputOperation(String fieldName) {
            this.fieldName = fieldName;
        }

        public BucketOptions addToSet(String field) {
            BucketOptions.this.accumulators.put(this.fieldName, new Accumulator("$addToSet", field));
            return BucketOptions.this;
        }

        public BucketOptions average(String field) {
            BucketOptions.this.accumulators.put(this.fieldName, new Accumulator("$avg", field));
            return BucketOptions.this;
        }

        public BucketOptions sum(Object field) {
            BucketOptions.this.accumulators.put(this.fieldName, new Accumulator("$sum", field));
            return BucketOptions.this;
        }
    }
}

