/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.annotations.Id;
import dev.morphia.annotations.Reference;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.FieldConstraint;
import java.util.Set;

public class ReferenceToUnidentifiable
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Reference.class)) {
            Class realType;
            Class clazz = realType = mf.isSingleValue() ? mf.getType() : mf.getSubClass();
            if (realType == null) {
                throw new MappingException("Type is null for this MappedField: " + mf);
            }
            if (!realType.isInterface() && mapper.getMappedClass(realType).getIdField() == null) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), mf.getFullName() + " is annotated as a @" + Reference.class.getSimpleName() + " but the " + mf.getType().getName() + " class is missing the @" + Id.class.getSimpleName() + " annotation"));
            }
        }
    }
}

