/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.fieldrules;

import dev.morphia.annotations.Reference;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.fieldrules.FieldConstraint;
import java.util.Set;

public class LazyReferenceOnArray
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        Class type;
        Reference ref = mf.getAnnotation(Reference.class);
        if (ref != null && ref.lazy() && (type = mf.getType()).isArray()) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "The lazy attribute cannot be used for an Array. If you need a lazy array please use ArrayList instead."));
        }
    }
}

