/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.classrules;

import dev.morphia.annotations.Version;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import dev.morphia.mapping.validation.classrules.FieldEnumString;
import java.util.List;
import java.util.Set;

public class MultipleVersions
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        List<MappedField> versionFields = mc.getFieldsAnnotatedWith(Version.class);
        if (versionFields.size() > 1) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), "Multiple @" + Version.class + " annotations are not allowed. (" + new FieldEnumString(versionFields)));
        }
    }
}

