/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.validation.classrules;

import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.validation.ClassConstraint;
import dev.morphia.mapping.validation.ConstraintViolation;
import java.util.HashSet;
import java.util.Set;

public class DuplicatedAttributeNames
implements ClassConstraint {
    @Override
    public void check(Mapper mapper, MappedClass mc, Set<ConstraintViolation> ve) {
        HashSet<String> foundNames = new HashSet<String>();
        for (MappedField mappedField : mc.getPersistenceFields()) {
            for (String name : mappedField.getLoadNames()) {
                if (foundNames.add(name)) continue;
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mappedField, this.getClass(), "Mapping to MongoDB field name '" + name + "' is duplicated; you cannot map different java fields to the same MongoDB field."));
            }
        }
    }
}

