/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.lazy.proxy;

import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.mapping.lazy.proxy.AbstractReference;
import dev.morphia.mapping.lazy.proxy.LazyReferenceFetchingException;
import dev.morphia.mapping.lazy.proxy.ProxiedEntityReference;

public class EntityObjectReference
extends AbstractReference
implements ProxiedEntityReference {
    private static final long serialVersionUID = 1L;
    private final Key key;

    public EntityObjectReference(Datastore datastore, Class targetClass, Key key, boolean ignoreMissing) {
        super(datastore, targetClass, ignoreMissing);
        this.key = key;
    }

    public Key __getKey() {
        return this.key;
    }

    @Override
    protected void beforeWriteObject() {
        this.object = null;
    }

    @Override
    protected Object fetch() {
        Object entity = this.getDatastore().getByKey(this.referenceObjClass, this.key);
        if (entity == null && !this.ignoreMissing) {
            throw new LazyReferenceFetchingException(String.format("During the lifetime of the proxy, the Entity identified by '%s' disappeared from the Datastore.", this.key));
        }
        return entity;
    }
}

