/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.lazy.proxy;

import com.thoughtworks.proxy.kit.ObjectReference;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.mapping.lazy.proxy.ProxiedReference;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractReference
implements Serializable,
ObjectReference,
ProxiedReference {
    private static final long serialVersionUID = 1L;
    private final Datastore datastore;
    protected final boolean ignoreMissing;
    protected final Class referenceObjClass;
    protected Object object;
    private boolean isFetched;

    protected AbstractReference(Datastore datastore, Class referenceObjClass, boolean ignoreMissing) {
        this.datastore = datastore;
        this.referenceObjClass = referenceObjClass;
        this.ignoreMissing = ignoreMissing;
    }

    @Override
    public final Class __getReferenceObjClass() {
        return this.referenceObjClass;
    }

    @Override
    public final boolean __isFetched() {
        return this.isFetched;
    }

    @Override
    public Object __unwrap() {
        return this.get();
    }

    public final synchronized Object get() {
        if (this.isFetched) {
            return this.object;
        }
        this.object = this.fetch();
        this.isFetched = true;
        return this.object;
    }

    public final void set(Object arg0) {
        throw new UnsupportedOperationException();
    }

    protected void beforeWriteObject() {
    }

    protected final Object fetch(Key<?> id) {
        return this.getDatastore().getByKey(this.referenceObjClass, id);
    }

    protected abstract Object fetch();

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.beforeWriteObject();
        this.isFetched = false;
        out.defaultWriteObject();
    }

    public Datastore getDatastore() {
        return this.datastore;
    }
}

