/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.lazy;

import dev.morphia.mapping.lazy.LazyProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyFeatureDependencies {
    private static final Logger LOG = LoggerFactory.getLogger(LazyFeatureDependencies.class);
    private static Boolean fulFilled;

    private LazyFeatureDependencies() {
    }

    public static boolean assertDependencyFullFilled() {
        boolean fulfilled = LazyFeatureDependencies.testDependencyFullFilled();
        if (!fulfilled) {
            LOG.warn("Lazy loading impossible due to missing dependencies.");
        }
        return fulfilled;
    }

    public static boolean testDependencyFullFilled() {
        if (fulFilled != null) {
            return fulFilled;
        }
        try {
            fulFilled = Class.forName("net.sf.cglib.proxy.Enhancer") != null && Class.forName("com.thoughtworks.proxy.toys.hotswap.HotSwapping") != null;
        }
        catch (ClassNotFoundException e) {
            fulFilled = false;
        }
        return fulFilled;
    }

    public static LazyProxyFactory createDefaultProxyFactory() {
        if (LazyFeatureDependencies.testDependencyFullFilled()) {
            String factoryClassName = "dev.morphia.mapping.lazy.CGLibLazyProxyFactory";
            try {
                return (LazyProxyFactory)Class.forName("dev.morphia.mapping.lazy.CGLibLazyProxyFactory").newInstance();
            }
            catch (Exception e) {
                LOG.error("While instantiating dev.morphia.mapping.lazy.CGLibLazyProxyFactory", e);
            }
        }
        return null;
    }
}

