/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.AdvancedDatastore;
import dev.morphia.Datastore;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.query.Query;

public class SingleReference<T>
extends MorphiaReference<T> {
    private Object id;
    private T value;

    SingleReference(Datastore datastore, MappedClass mappedClass, Object id) {
        super(datastore, mappedClass);
        this.id = id;
    }

    SingleReference(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        if (this.value == null && this.id != null) {
            this.value = this.buildQuery().find().tryNext();
        }
        return this.value;
    }

    Query<?> buildQuery() {
        Query<?> query;
        if (this.id instanceof DBRef) {
            Class<?> clazz = this.getDatastore().getMapper().getClassFromCollection(((DBRef)this.id).getCollectionName());
            query = ((AdvancedDatastore)this.getDatastore()).find(clazz).filter("_id", ((DBRef)this.id).getId());
        } else {
            query = ((AdvancedDatastore)this.getDatastore()).find(this.getMappedClass().getClazz()).filter("_id", this.id);
        }
        return query;
    }

    Object getId() {
        return this.id;
    }

    @Override
    public boolean isResolved() {
        return this.value != null;
    }

    @Override
    public Object encode(Mapper mapper, Object value, MappedField optionalExtraInfo) {
        if (this.isResolved()) {
            return SingleReference.wrapId(mapper, optionalExtraInfo, this.get());
        }
        return null;
    }

    public static MorphiaReference<?> decode(Datastore datastore, Mapper mapper, MappedField mappedField, Class paramType, DBObject dbObject) {
        MappedClass mappedClass = mapper.getMappedClass(paramType);
        Object id = dbObject.get(mappedField.getMappedFieldName());
        return new SingleReference(datastore, mappedClass, id);
    }
}

