/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.AdvancedDatastore;
import dev.morphia.Datastore;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.experimental.CollectionReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.query.internal.MorphiaCursor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapReference<T>
extends MorphiaReference<Map<String, T>> {
    private Map<String, Object> ids;
    private Map<String, T> values;
    private Map<String, List<Object>> collections = new HashMap<String, List<Object>>();

    MapReference(Datastore datastore, MappedClass mappedClass, Map<String, Object> ids) {
        super(datastore, mappedClass);
        Map<String, Object> unwrapped = ids;
        if (ids != null) {
            for (Map.Entry<String, Object> entry : ids.entrySet()) {
                CollectionReference.collate(datastore, this.collections, entry.getValue());
            }
        }
        this.ids = unwrapped;
    }

    MapReference(Map<String, T> values) {
        this.values = values;
    }

    @Override
    public Map<String, T> get() {
        if (this.values == null && this.ids != null) {
            this.values = new LinkedHashMap<String, T>();
            this.mergeReads();
        }
        return this.values;
    }

    private void mergeReads() {
        for (Map.Entry<String, List<Object>> entry : this.collections.entrySet()) {
            this.readFromSingleCollection(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromSingleCollection(String collection, List<Object> collectionIds) {
        Class<?> collectionType = this.getMappedClass().getClazz();
        try (MorphiaCursor<?> cursor = ((AdvancedDatastore)this.getDatastore()).find(collection, collectionType).filter("_id in ", collectionIds).find();){
            HashMap idMap = new HashMap();
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                idMap.put(this.getDatastore().getMapper().getId(entity), entity);
            }
            for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
                Object id = entry.getValue();
                Object value = idMap.get(id instanceof DBRef ? ((DBRef)id).getId() : id);
                if (value == null) continue;
                this.values.put(entry.getKey(), value);
            }
        }
    }

    @Override
    public boolean isResolved() {
        return this.values != null;
    }

    @Override
    public Object encode(Mapper mapper, Object value, MappedField field) {
        if (this.isResolved()) {
            LinkedHashMap<String, Object> ids = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : this.get().entrySet()) {
                ids.put((String)entry.getKey(), MapReference.wrapId(mapper, field, entry.getValue()));
            }
            return ids;
        }
        return null;
    }

    public static MapReference decode(Datastore datastore, Mapper mapper, MappedField mappedField, DBObject dbObject) {
        Class subType = mappedField.getTypeParameters().get(0).getSubClass();
        Map ids = (Map)mappedField.getDbObjectValue(dbObject);
        MapReference reference = null;
        if (ids != null) {
            reference = new MapReference(datastore, mapper.getMappedClass(subType), ids);
        }
        return reference;
    }
}

