/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import dev.morphia.AdvancedDatastore;
import dev.morphia.Datastore;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.query.internal.MorphiaCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CollectionReference<C extends Collection>
extends MorphiaReference<C> {
    private List<Object> ids;
    private Map<String, List<Object>> collections = new HashMap<String, List<Object>>();

    CollectionReference() {
    }

    CollectionReference(Datastore datastore, MappedClass mappedClass, List ids) {
        super(datastore, mappedClass);
        List unwrapped = ids;
        if (ids != null) {
            for (Object o : ids) {
                CollectionReference.collate(datastore, this.collections, o);
            }
        }
        this.ids = unwrapped;
    }

    static void collate(Datastore datastore, Map<String, List<Object>> collections, Object o) {
        Object id;
        String collectionName;
        if (o instanceof DBRef) {
            DBRef dbRef = (DBRef)o;
            collectionName = dbRef.getCollectionName();
            id = dbRef.getId();
        } else {
            collectionName = datastore.getMapper().getCollectionName(o);
            id = o;
        }
        CollectionReference.register(collections, collectionName).add(id);
    }

    static List register(Map<String, List<Object>> collections, String name) {
        List<Object> list = collections.get(name);
        if (list == null) {
            list = new ArrayList<Object>();
            collections.put(name, list);
        }
        return list;
    }

    @Override
    public final boolean isResolved() {
        return this.getValues() != null;
    }

    abstract Collection<?> getValues();

    @Override
    public abstract C get();

    final List<Object> getIds() {
        return this.ids;
    }

    final List<?> find() {
        ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(new Object[this.ids.size()]));
        for (Map.Entry<String, List<Object>> entry : this.collections.entrySet()) {
            this.query(entry.getKey(), entry.getValue(), values);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void query(String collection, List<Object> collectionIds, List<Object> values) {
        try (MorphiaCursor<Object> cursor = ((AdvancedDatastore)this.getDatastore()).find(collection, Object.class).disableValidation().filter("_id in ", collectionIds).find();){
            HashMap idMap = new HashMap();
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                idMap.put(this.getDatastore().getMapper().getId(entity), entity);
            }
            for (int i = 0; i < this.ids.size(); ++i) {
                Object id = this.ids.get(i);
                Object value = idMap.get(id instanceof DBRef ? ((DBRef)id).getId() : id);
                if (value == null) continue;
                values.set(i, value);
            }
        }
    }

    @Override
    public Object encode(Mapper mapper, Object value, MappedField field) {
        if (this.isResolved()) {
            ArrayList<Object> ids = new ArrayList<Object>();
            Iterator iterator = this.get().iterator();
            while (iterator.hasNext()) {
                Object entity = iterator.next();
                ids.add(CollectionReference.wrapId(mapper, field, entity));
            }
            return ids;
        }
        return null;
    }

    public static MorphiaReference<?> decode(Datastore datastore, Mapper mapper, MappedField mappedField, Class paramType, DBObject dbObject) {
        CollectionReference reference = null;
        List dbVal = (List)mappedField.getDbObjectValue(dbObject);
        if (dbVal != null) {
            Class subType = mappedField.getTypeParameters().get(0).getSubClass();
            MappedClass mappedClass = mapper.getMappedClass(subType);
            reference = Set.class.isAssignableFrom(paramType) ? new SetReference(datastore, mappedClass, dbVal) : new ListReference(datastore, mappedClass, dbVal);
        }
        return reference;
    }
}

