/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import dev.morphia.ObjectFactory;
import dev.morphia.mapping.CustomMapper;
import dev.morphia.mapping.DateStorage;
import dev.morphia.mapping.DefaultCreator;
import dev.morphia.mapping.EmbeddedMapper;
import dev.morphia.mapping.ReferenceMapper;
import dev.morphia.mapping.ValueMapper;
import dev.morphia.mapping.cache.DefaultEntityCacheFactory;
import dev.morphia.mapping.cache.EntityCacheFactory;
import dev.morphia.mapping.lazy.DatastoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperOptions {
    private static final Logger LOG = LoggerFactory.getLogger(MapperOptions.class);
    private boolean ignoreFinals;
    private boolean storeNulls;
    private boolean storeEmpties;
    private boolean useLowerCaseCollectionNames;
    private boolean cacheClassLookups;
    private boolean mapSubPackages;
    private boolean disableEmbeddedIndexes;
    private DateStorage dateStorage = DateStorage.SYSTEM_DEFAULT;
    private ObjectFactory objectFactory;
    private EntityCacheFactory cacheFactory = new DefaultEntityCacheFactory();
    private CustomMapper embeddedMapper;
    private CustomMapper defaultMapper = this.embeddedMapper = new EmbeddedMapper();
    private CustomMapper referenceMapper = new ReferenceMapper();
    private CustomMapper valueMapper = new ValueMapper();
    private ClassLoader classLoader;

    @Deprecated
    public MapperOptions() {
    }

    @Deprecated
    public MapperOptions(MapperOptions options) {
        this.ignoreFinals = options.isIgnoreFinals();
        this.storeNulls = options.isStoreNulls();
        this.storeEmpties = options.isStoreEmpties();
        this.useLowerCaseCollectionNames = options.isUseLowerCaseCollectionNames();
        this.cacheClassLookups = options.isCacheClassLookups();
        this.objectFactory = options.getObjectFactory();
        this.cacheFactory = options.getCacheFactory();
        this.embeddedMapper = options.getEmbeddedMapper();
        this.defaultMapper = options.getDefaultMapper();
        this.referenceMapper = options.getReferenceMapper();
        this.valueMapper = options.getValueMapper();
        this.mapSubPackages = options.isMapSubPackages();
        this.dateStorage = options.dateStorage;
        this.disableEmbeddedIndexes = options.disableEmbeddedIndexes;
        this.classLoader = options.getClassLoader();
    }

    private MapperOptions(Builder builder) {
        this.ignoreFinals = builder.ignoreFinals;
        this.disableEmbeddedIndexes = builder.disableEmbeddedIndexes;
        this.storeNulls = builder.storeNulls;
        this.storeEmpties = builder.storeEmpties;
        this.useLowerCaseCollectionNames = builder.useLowerCaseCollectionNames;
        this.cacheClassLookups = builder.cacheClassLookups;
        this.mapSubPackages = builder.mapSubPackages;
        this.objectFactory = builder.objectFactory;
        this.cacheFactory = builder.cacheFactory;
        this.embeddedMapper = builder.embeddedMapper;
        this.defaultMapper = builder.defaultMapper;
        this.referenceMapper = builder.referenceMapper;
        this.valueMapper = builder.valueMapper;
        this.dateStorage = builder.dateStorage;
        this.classLoader = builder.classLoader;
    }

    public EntityCacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    @Deprecated
    public void setCacheFactory(EntityCacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Deprecated
    public DatastoreProvider getDatastoreProvider() {
        return null;
    }

    @Deprecated
    public void setDatastoreProvider(DatastoreProvider unused) {
        LOG.warn("DatastoreProviders are no longer needed or used.");
    }

    public CustomMapper getDefaultMapper() {
        return this.defaultMapper;
    }

    @Deprecated
    public void setDefaultMapper(CustomMapper pDefaultMapper) {
        this.defaultMapper = pDefaultMapper;
    }

    public CustomMapper getEmbeddedMapper() {
        return this.embeddedMapper;
    }

    @Deprecated
    public void setEmbeddedMapper(CustomMapper pEmbeddedMapper) {
        this.embeddedMapper = pEmbeddedMapper;
    }

    public ObjectFactory getObjectFactory() {
        if (this.objectFactory == null) {
            this.objectFactory = new DefaultCreator(this);
        }
        return this.objectFactory;
    }

    @Deprecated
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public CustomMapper getReferenceMapper() {
        return this.referenceMapper;
    }

    @Deprecated
    public void setReferenceMapper(CustomMapper pReferenceMapper) {
        this.referenceMapper = pReferenceMapper;
    }

    public CustomMapper getValueMapper() {
        return this.valueMapper;
    }

    @Deprecated
    public void setValueMapper(CustomMapper pValueMapper) {
        this.valueMapper = pValueMapper;
    }

    @Deprecated
    public boolean isActLikeSerializer() {
        return true;
    }

    @Deprecated
    public void setActLikeSerializer(boolean ignored) {
    }

    public boolean isCacheClassLookups() {
        return this.cacheClassLookups;
    }

    @Deprecated
    public void setCacheClassLookups(boolean cacheClassLookups) {
        this.cacheClassLookups = cacheClassLookups;
    }

    public boolean isIgnoreFinals() {
        return this.ignoreFinals;
    }

    @Deprecated
    public void setIgnoreFinals(boolean ignoreFinals) {
        this.ignoreFinals = ignoreFinals;
    }

    public boolean isStoreEmpties() {
        return this.storeEmpties;
    }

    @Deprecated
    public void setStoreEmpties(boolean storeEmpties) {
        this.storeEmpties = storeEmpties;
    }

    public boolean isStoreNulls() {
        return this.storeNulls;
    }

    @Deprecated
    public void setStoreNulls(boolean storeNulls) {
        this.storeNulls = storeNulls;
    }

    public boolean isUseLowerCaseCollectionNames() {
        return this.useLowerCaseCollectionNames;
    }

    @Deprecated
    public void setUseLowerCaseCollectionNames(boolean useLowerCaseCollectionNames) {
        this.useLowerCaseCollectionNames = useLowerCaseCollectionNames;
    }

    public boolean isDisableEmbeddedIndexes() {
        return this.disableEmbeddedIndexes;
    }

    public boolean isMapSubPackages() {
        return this.mapSubPackages;
    }

    @Deprecated
    public void setMapSubPackages(boolean mapSubPackages) {
        this.mapSubPackages = mapSubPackages;
    }

    public String getDiscriminatorField() {
        return "className";
    }

    public void setDisableEmbeddedIndexes(boolean disableEmbeddedIndexes) {
        this.disableEmbeddedIndexes = disableEmbeddedIndexes;
    }

    public DateStorage getDateStorage() {
        return this.dateStorage;
    }

    @Deprecated
    public void setDateStorage(DateStorage dateStorage) {
        this.dateStorage = dateStorage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MapperOptions original) {
        Builder builder = new Builder();
        builder.ignoreFinals = original.isIgnoreFinals();
        builder.storeNulls = original.isStoreNulls();
        builder.storeEmpties = original.isStoreEmpties();
        builder.useLowerCaseCollectionNames = original.isUseLowerCaseCollectionNames();
        builder.cacheClassLookups = original.isCacheClassLookups();
        builder.mapSubPackages = original.isMapSubPackages();
        builder.objectFactory = original.getObjectFactory();
        builder.cacheFactory = original.getCacheFactory();
        builder.embeddedMapper = original.getEmbeddedMapper();
        builder.defaultMapper = original.getDefaultMapper();
        builder.referenceMapper = original.getReferenceMapper();
        builder.valueMapper = original.getValueMapper();
        builder.disableEmbeddedIndexes = original.isDisableEmbeddedIndexes();
        builder.classLoader = original.getClassLoader();
        return builder;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    public static final class Builder {
        private boolean ignoreFinals;
        private boolean storeNulls;
        private boolean storeEmpties;
        private boolean useLowerCaseCollectionNames;
        private boolean cacheClassLookups;
        private boolean mapSubPackages;
        private boolean disableEmbeddedIndexes;
        private DateStorage dateStorage = DateStorage.SYSTEM_DEFAULT;
        private ObjectFactory objectFactory;
        private ClassLoader classLoader;
        private EntityCacheFactory cacheFactory = new DefaultEntityCacheFactory();
        private CustomMapper embeddedMapper;
        private CustomMapper defaultMapper = this.embeddedMapper = new EmbeddedMapper();
        private CustomMapper referenceMapper = new ReferenceMapper();
        private CustomMapper valueMapper = new ValueMapper();

        private Builder() {
        }

        @Deprecated
        public Builder actLikeSerializer(boolean actLikeSerializer) {
            return this;
        }

        public Builder ignoreFinals(boolean ignoreFinals) {
            this.ignoreFinals = ignoreFinals;
            return this;
        }

        public Builder storeNulls(boolean storeNulls) {
            this.storeNulls = storeNulls;
            return this;
        }

        public Builder storeEmpties(boolean storeEmpties) {
            this.storeEmpties = storeEmpties;
            return this;
        }

        public Builder useLowerCaseCollectionNames(boolean useLowerCaseCollectionNames) {
            this.useLowerCaseCollectionNames = useLowerCaseCollectionNames;
            return this;
        }

        public Builder cacheClassLookups(boolean cacheClassLookups) {
            this.cacheClassLookups = cacheClassLookups;
            return this;
        }

        public Builder mapSubPackages(boolean mapSubPackages) {
            this.mapSubPackages = mapSubPackages;
            return this;
        }

        public Builder disableEmbeddedIndexes(boolean disableEmbeddedIndexes) {
            this.disableEmbeddedIndexes = disableEmbeddedIndexes;
            return this;
        }

        public Builder objectFactory(ObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public Builder cacheFactory(EntityCacheFactory cacheFactory) {
            this.cacheFactory = cacheFactory;
            return this;
        }

        public Builder embeddedMapper(CustomMapper embeddedMapper) {
            this.embeddedMapper = embeddedMapper;
            return this;
        }

        public Builder defaultMapper(CustomMapper defaultMapper) {
            this.defaultMapper = defaultMapper;
            return this;
        }

        public Builder referenceMapper(CustomMapper referenceMapper) {
            this.referenceMapper = referenceMapper;
            return this;
        }

        public Builder valueMapper(CustomMapper valueMapper) {
            this.valueMapper = valueMapper;
            return this;
        }

        @Deprecated
        public Builder dateForm(DateStorage dateStorage) {
            this.dateStorage = dateStorage;
            return this;
        }

        public Builder datastoreProvider(DatastoreProvider datastoreProvider) {
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public MapperOptions build() {
            return new MapperOptions(this);
        }
    }
}

