/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.geo;

import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import dev.morphia.geo.CoordinateReferenceSystem;
import dev.morphia.geo.GeoJson;
import dev.morphia.geo.Geometry;
import dev.morphia.geo.LineString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Polygon
implements Geometry {
    private final LineString exteriorBoundary;
    private final List<LineString> interiorBoundaries;

    private Polygon() {
        this.exteriorBoundary = null;
        this.interiorBoundaries = new ArrayList<LineString>();
    }

    Polygon(LineString exteriorBoundary, LineString ... interiorBoundaries) {
        this.exteriorBoundary = exteriorBoundary;
        this.interiorBoundaries = Arrays.asList(interiorBoundaries);
    }

    Polygon(List<LineString> boundaries) {
        this.exteriorBoundary = boundaries.get(0);
        this.interiorBoundaries = boundaries.size() > 1 ? boundaries.subList(1, boundaries.size()) : new ArrayList<LineString>();
    }

    public List<LineString> getCoordinates() {
        ArrayList<LineString> polygonBoundaries = new ArrayList<LineString>();
        polygonBoundaries.add(this.exteriorBoundary);
        polygonBoundaries.addAll(this.interiorBoundaries);
        return polygonBoundaries;
    }

    public LineString getExteriorBoundary() {
        return this.exteriorBoundary;
    }

    public List<LineString> getInteriorBoundaries() {
        return Collections.unmodifiableList(this.interiorBoundaries);
    }

    public int hashCode() {
        int result = this.exteriorBoundary.hashCode();
        result = 31 * result + this.interiorBoundaries.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        if (!this.exteriorBoundary.equals(polygon.exteriorBoundary)) {
            return false;
        }
        return this.interiorBoundaries.equals(polygon.interiorBoundaries);
    }

    public String toString() {
        return "Polygon{exteriorBoundary=" + this.exteriorBoundary + ", interiorBoundaries=" + this.interiorBoundaries + '}';
    }

    @Override
    public com.mongodb.client.model.geojson.Polygon convert() {
        return this.convert(null);
    }

    @Override
    public com.mongodb.client.model.geojson.Polygon convert(CoordinateReferenceSystem crs) {
        List<List<Position>> lists = GeoJson.convertLineStrings(this.interiorBoundaries);
        List[] holeArray = lists.toArray(new List[0]);
        return new com.mongodb.client.model.geojson.Polygon(crs != null ? crs.convert() : null, new PolygonCoordinates(this.exteriorBoundary.convert().getCoordinates(), holeArray));
    }
}

